/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class MathUtil {
    public static String formatDecimals(double value, int decimals, boolean keepZeros) {
        if (keepZeros) {
            return String.format(Locale.US, "%." + decimals + "f", value);
        }
        String pattern = decimals == 0 ? "###" : "###." + new String(new char[decimals]).replace("\u0000", "#");
        return new DecimalFormat(pattern, new DecimalFormatSymbols(Locale.US)).format(value);
    }

    public static Integer parseInt(String value, Integer defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NullPointerException | NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Double parseDouble(String value, Double defaultValue) {
        try {
            return Double.parseDouble(value);
        }
        catch (NullPointerException | NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Float parseFloat(String value, Float defaultValue) {
        try {
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (NullPointerException | NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int constrain(int value, int min, int max) {
        if (min > max) {
            int temp = min;
            min = max;
            max = temp;
        }
        return Math.max(min, Math.min(max, value));
    }

    public static int sqr(int v) {
        return v * v;
    }

    public static double strictMap(double v, double from, double to, double newFrom, double newTo) {
        return MathUtil.constrain(MathUtil.map(v, from, to, newFrom, newTo), newFrom, newTo);
    }

    public static double constrain(double value, double min, double max) {
        if (min > max) {
            double temp = min;
            min = max;
            max = temp;
        }
        return Math.max(min, Math.min(max, value));
    }

    public static double constrain01(double value) {
        return MathUtil.constrain(value, 0.0, 1.0);
    }

    public static double map(double v, double from, double to, double newFrom, double newTo) {
        return (v - from) / (to - from) * (newTo - newFrom) + newFrom;
    }

    public static int map(int v, int from, int to, int newFrom, int newTo) {
        return (int)MathUtil.map((double)v, (double)from, (double)to, (double)newFrom, (double)newTo);
    }

    public static double roundToStep(double value, double step) {
        return (double)Math.round(value / step) * step;
    }

    public static double distance(double v1, double v2) {
        return Math.abs(v1 - v2);
    }

    public static float wrapDegrees(float value) {
        if ((value %= 360.0f) >= 180.0f) {
            value -= 360.0f;
        }
        if (value < -180.0f) {
            value += 360.0f;
        }
        return value;
    }
}

