/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.kurrycat.mpkmod.gui.infovars.InfoString;
import io.github.kurrycat.mpkmod.util.Copyable;
import io.github.kurrycat.mpkmod.util.FormatDecimals;
import io.github.kurrycat.mpkmod.util.MathUtil;

@InfoString.DataClass
public class Vector2D
implements Copyable<Vector2D>,
FormatDecimals {
    public static final Vector2D ONE = new Vector2D(1.0, 1.0);
    public static final Vector2D ZERO = new Vector2D(0.0, 0.0);
    public static final Vector2D OFFSCREEN = new Vector2D(Double.MIN_VALUE, Double.MIN_VALUE);
    public static final Vector2D LEFT = new Vector2D(-1.0, 0.0);
    public static final Vector2D RIGHT = new Vector2D(1.0, 0.0);
    public static final Vector2D UP = new Vector2D(0.0, -1.0);
    public static final Vector2D DOWN = new Vector2D(0.0, 1.0);
    protected double x;
    protected double y;

    @JsonCreator
    public Vector2D(@JsonProperty(value="x") double x, @JsonProperty(value="y") double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D(Vector2D vector2D) {
        this.x = vector2D.x;
        this.y = vector2D.y;
    }

    @JsonIgnore
    public float getXF() {
        return (float)this.x;
    }

    @JsonIgnore
    public int getXI() {
        return (int)this.x;
    }

    @JsonIgnore
    public float getYF() {
        return (float)this.y;
    }

    @JsonIgnore
    public int getYI() {
        return (int)this.y;
    }

    public Vector2D set(Vector2D vector2D) {
        this.setX(vector2D.getX());
        this.setY(vector2D.getY());
        return this;
    }

    @InfoString.Getter
    @JsonProperty(value="x")
    public double getX() {
        return this.x;
    }

    @JsonProperty(value="x")
    public Vector2D setX(double x) {
        this.x = x;
        return this;
    }

    @InfoString.Getter
    @JsonProperty(value="y")
    public double getY() {
        return this.y;
    }

    @JsonProperty(value="y")
    public Vector2D setY(double y) {
        this.y = y;
        return this;
    }

    public Vector2D set(double x, double y) {
        this.setX(x);
        this.setY(y);
        return this;
    }

    public Vector2D add(double v) {
        return this.add(new Vector2D(v, v));
    }

    public Vector2D add(Vector2D v) {
        return new Vector2D(this.x + v.x, this.y + v.y);
    }

    public Vector2D sub(double v) {
        return new Vector2D(this.x - v, this.y - v);
    }

    public Vector2D sub(double x, double y) {
        return new Vector2D(this.x - x, this.y - y);
    }

    public Vector2D mult(Vector2D v) {
        return new Vector2D(this.x * v.x, this.y * v.y);
    }

    public Vector2D mult(double v) {
        return new Vector2D(this.x * v, this.y * v);
    }

    public Vector2D div(double v) {
        return new Vector2D(this.x / v, this.y / v);
    }

    public Vector2D div(Vector2D v) {
        return new Vector2D(this.x / v.x, this.y / v.y);
    }

    public Vector2D asInRange(Vector2D from, Vector2D to) {
        Vector2D diff = to.sub(from);
        Vector2D curr = this.copy();
        while (curr.getX() < from.getX()) {
            curr.addXInPlace(diff.getX());
        }
        while (curr.getY() < from.getY()) {
            curr.addYInPlace(diff.getY());
        }
        while (curr.getX() > to.getX()) {
            curr.subXInPlace(diff.getX());
        }
        while (curr.getY() > to.getY()) {
            curr.subYInPlace(diff.getY());
        }
        return curr;
    }

    public Vector2D sub(Vector2D v) {
        return new Vector2D(this.x - v.x, this.y - v.y);
    }

    @Override
    public Vector2D copy() {
        return new Vector2D(this.x, this.y);
    }

    public Vector2D addXInPlace(double x) {
        this.x += x;
        return this;
    }

    public Vector2D addYInPlace(double y) {
        this.y += y;
        return this;
    }

    public Vector2D subXInPlace(double x) {
        return this.addXInPlace(-x);
    }

    public Vector2D subYInPlace(double y) {
        return this.addYInPlace(-y);
    }

    public double dist(Vector2D other) {
        return this.sub(other).length();
    }

    public double length() {
        return Math.sqrt(this.lengthSqr());
    }

    public double lengthSqr() {
        return this.x * this.x + this.y * this.y;
    }

    public Vector2D add(double x, double y) {
        return new Vector2D(this.x + x, this.y + y);
    }

    public double dot(Vector2D other) {
        return this.x * other.x + this.y * other.y;
    }

    public Vector2D normalize() {
        double len = this.length();
        if (len == 0.0) {
            return ZERO;
        }
        return new Vector2D(this.x / len, this.y / len);
    }

    public boolean isInRectBetween(Vector2D pos1, Vector2D pos2) {
        return this.x >= pos1.x && this.x <= pos2.x && this.y >= pos1.y && this.y <= pos2.y;
    }

    public int hashCode() {
        return Double.hashCode(this.x) + Double.hashCode(this.y);
    }

    public boolean equals(Object obj) {
        return obj instanceof Vector2D && ((Vector2D)obj).equals(this);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + "]";
    }

    public boolean equals(Vector2D other) {
        return other.x == this.x && other.y == this.y;
    }

    public Vector2D constrain(Vector2D v1, Vector2D v2) {
        return new Vector2D(MathUtil.constrain(this.x, v1.x, v2.x), MathUtil.constrain(this.y, v1.y, v2.y));
    }

    public Vector2D round() {
        return new Vector2D(Math.round(this.x), Math.round(this.y));
    }

    public Vector2D abs() {
        return new Vector2D(Math.abs(this.x), Math.abs(this.y));
    }

    @Override
    public String formatDecimals(int decimals, boolean keepZeros) {
        return "[" + MathUtil.formatDecimals(this.x, decimals, keepZeros) + "," + MathUtil.formatDecimals(this.y, decimals, keepZeros) + "]";
    }

    public boolean isInRectBetweenPS(Vector2D pos, Vector2D size) {
        return pos.x <= this.x && pos.x + size.x >= this.x && pos.y <= this.y && pos.y + size.y >= this.y;
    }
}

