/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.compatibility.MCClasses;

import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.FunctionHolder;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;

public class Renderer2D {
    public static void drawRectWithEdge(Vector2D pos, Vector2D size, double edgeThickness, Color fillColor, Color edgeColor) {
        Renderer2D.drawRect(pos, size, fillColor);
        Renderer2D.drawHollowRect(pos.add(edgeThickness), size.sub(edgeThickness * 2.0), edgeThickness, edgeColor);
    }

    public static void drawRect(Vector2D pos, Vector2D size, Color color) {
        Optional<Interface> renderer = Interface.get();
        renderer.ifPresent(renderer2DInterface -> renderer2DInterface.drawRect(pos, size, color));
    }

    public static void drawHollowRect(Vector2D pos, Vector2D size, double edgeThickness, Color color) {
        Renderer2D.drawRect(pos.sub(edgeThickness), new Vector2D(size.getX() + edgeThickness * 2.0, edgeThickness), color);
        Renderer2D.drawRect(pos.add(-edgeThickness, size.getY()), new Vector2D(size.getX() + edgeThickness * 2.0, edgeThickness), color);
        Renderer2D.drawRect(pos.sub(edgeThickness, 0.0), new Vector2D(edgeThickness, size.getY()), color);
        Renderer2D.drawRect(pos.add(size.getX(), 0.0), new Vector2D(edgeThickness, size.getY()), color);
    }

    public static void drawDottedRect(Vector2D pos, Vector2D size, double spacing, double dashLength, double edgeThickness, Color color) {
        double i;
        Vector2D hDot = new Vector2D(dashLength, edgeThickness);
        Vector2D vDot = new Vector2D(edgeThickness, dashLength);
        for (i = pos.getX() - edgeThickness; i <= pos.getX() + size.getX() + edgeThickness - dashLength; i += spacing + dashLength) {
            Renderer2D.drawRect(new Vector2D(i, pos.getY() - edgeThickness), hDot, color);
        }
        for (i = pos.getY() - edgeThickness; i <= pos.getY() + size.getY() + edgeThickness - dashLength; i += spacing + dashLength) {
            Renderer2D.drawRect(new Vector2D(pos.getX() + size.getX(), i), vDot, color);
        }
        for (i = pos.getX() + size.getX(); i >= pos.getX(); i -= spacing + dashLength) {
            Renderer2D.drawRect(new Vector2D(i, pos.getY() + size.getY()), hDot, color);
        }
        for (i = pos.getY() + size.getY(); i >= pos.getY(); i -= spacing + dashLength) {
            Renderer2D.drawRect(new Vector2D(pos.getX() - edgeThickness, i), vDot, color);
        }
    }

    public static Vector2D getScaledSize() {
        return Interface.get().map(Interface::getScaledSize).orElse(new Vector2D(800.0, 600.0));
    }

    public static Vector2D getScreenSize() {
        return Interface.get().map(Interface::getScreenSize).orElse(new Vector2D(800.0, 600.0));
    }

    public static void drawLine(Vector2D p1, Vector2D p2, Color color) {
        Renderer2D.drawLines(Arrays.asList(p1, p2), color);
    }

    public static void drawLines(Collection<Vector2D> points, Color color) {
        Optional<Interface> renderer = Interface.get();
        renderer.ifPresent(renderer2DInterface -> renderer2DInterface.drawLines(points, color));
    }

    public static void enableScissor(double x, double y, double w, double h) {
        Optional<Interface> renderer = Interface.get();
        renderer.ifPresent(renderer2DInterface -> renderer2DInterface.enableScissor(x, y, w, h));
    }

    public static void endFrame() {
        Optional<Interface> renderer = Interface.get();
        renderer.ifPresent(Interface::clearScissors);
    }

    public static void disableScissor() {
        Optional<Interface> renderer = Interface.get();
        renderer.ifPresent(Interface::disableScissor);
    }

    public static boolean scissorContains(Vector2D point) {
        Optional<Interface> renderer = Interface.get();
        return renderer.map(renderer2DInterface -> renderer2DInterface.scissorContains(point)).orElse(false);
    }

    public static interface Interface
    extends FunctionHolder {
        public static Optional<Interface> get() {
            return API.getFunctionHolder(Interface.class);
        }

        public void drawRect(Vector2D var1, Vector2D var2, Color var3);

        public void drawLines(Collection<Vector2D> var1, Color var2);

        public Vector2D getScaledSize();

        public Vector2D getScreenSize();

        public void enableScissor(double var1, double var3, double var5, double var7);

        public void disableScissor();

        public void clearScissors();

        public boolean scissorContains(Vector2D var1);
    }
}

