/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.compatibility.forge_1_8;

import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.KeyBinding;
import io.github.kurrycat.mpkmod.compatibility.forge_1_8.EventListener;
import io.github.kurrycat.mpkmod.compatibility.forge_1_8.FunctionCompatibility;
import io.github.kurrycat.mpkmod.compatibility.forge_1_8.network.MPKForgeNetworking;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="mpkmod", version="2.0", name="MPK Mod", acceptedMinecraftVersions="*")
public class MPKMod {
    public static Map<String, net.minecraft.client.settings.KeyBinding> keyBindingMap = new HashMap<String, net.minecraft.client.settings.KeyBinding>();
    public static final MPKForgeNetworking FORGE_NETWORKING = new MPKForgeNetworking();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        FORGE_NETWORKING.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        API.preInit(this.getClass());
        API.guiScreenMap.forEach((id, guiScreen) -> {
            if (guiScreen.shouldCreateKeyBind()) {
                MPKMod.registerKeyBinding(id);
            }
        });
        API.keyBindingMap.forEach((id, consumer) -> MPKMod.registerKeyBinding(id));
        API.LOGGER.info(API.COMPATIBILITY_MARKER, "Registering compatibility functions...");
        API.registerFunctionHolder(new FunctionCompatibility());
        API.LOGGER.info(API.COMPATIBILITY_MARKER, "Done");
        MinecraftForge.EVENT_BUS.register((Object)new EventListener());
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.registerKeyBindings();
        API.init((String)Minecraft.func_175596_ai().get("X-Minecraft-Version"));
    }

    public static void registerKeyBinding(String id) {
        net.minecraft.client.settings.KeyBinding keyBinding = new net.minecraft.client.settings.KeyBinding("mpkmod.key." + id + ".desc", 0, "MPK Mod");
        keyBindingMap.put(id, keyBinding);
        ClientRegistry.registerKeyBinding((net.minecraft.client.settings.KeyBinding)keyBinding);
    }

    private void registerKeyBindings() {
        for (net.minecraft.client.settings.KeyBinding k : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
            new KeyBinding(() -> GameSettings.func_74298_c((int)k.func_151463_i()), k.func_151464_g(), () -> ((net.minecraft.client.settings.KeyBinding)k).func_151470_d());
        }
        API.LOGGER.info(API.COMPATIBILITY_MARKER, "Registered {} Keybindings", new Object[]{KeyBinding.getKeyMap().size()});
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent e) {
        API.Events.onLoadComplete();
    }
}

