/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.events;

import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Player;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Profiler;
import io.github.kurrycat.mpkmod.events.Event;
import io.github.kurrycat.mpkmod.events.OnRenderOverlayEvent;
import io.github.kurrycat.mpkmod.events.OnTickEndEvent;
import io.github.kurrycat.mpkmod.events.OnTickStartEvent;
import io.github.kurrycat.mpkmod.util.Debug;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.function.Consumer;

public class EventAPI {
    private static final EventListenerMap listeners = new EventListenerMap();
    private static String currentModuleID = null;

    public static void addListener(EventListener<?> listener) {
        if (currentModuleID == null) {
            Debug.stacktrace("You can't add event listeners outside of MPKModule.loaded()");
            return;
        }
        listeners.addListener(currentModuleID, listener);
    }

    public static void loading(String moduleID) {
        currentModuleID = moduleID;
        listeners.forEach((type, map) -> {
            if (map.containsKey(currentModuleID)) {
                ((ArrayList)map.get(currentModuleID)).clear();
            }
        });
    }

    public static void finishLoading() {
        currentModuleID = null;
    }

    public static void unload(String moduleID) {
        listeners.forEach((type, map) -> {
            if (map.containsKey(moduleID)) {
                ((ArrayList)map.get(moduleID)).clear();
            }
        });
    }

    public static void postEvent(Event event) {
        if (Player.getLatest() != null) {
            listeners.postEvent(event);
        }
    }

    public static void init() {
    }

    public static class EventListener<T extends Event> {
        private final Consumer<T> runnable;
        private final Event.EventType type;

        public EventListener(Consumer<T> runnable, Event.EventType type) {
            this.runnable = runnable;
            this.type = type;
        }

        public static EventListener<OnTickStartEvent> onTickStart(Consumer<OnTickStartEvent> runnable) {
            return new EventListener<OnTickStartEvent>(runnable, Event.EventType.TICK_START);
        }

        public static EventListener<OnTickEndEvent> onTickEnd(Consumer<OnTickEndEvent> runnable) {
            return new EventListener<OnTickEndEvent>(runnable, Event.EventType.TICK_END);
        }

        public static EventListener<OnRenderOverlayEvent> onRenderOverlay(Consumer<OnRenderOverlayEvent> runnable) {
            return new EventListener<OnRenderOverlayEvent>(runnable, Event.EventType.RENDER_OVERLAY);
        }

        public Event.EventType getType() {
            return this.type;
        }

        public void run(Event event) {
            this.runnable.accept(event);
        }
    }

    public static class EventListenerMap
    extends EnumMap<Event.EventType, HashMap<String, ArrayList<EventListener<?>>>> {
        public EventListenerMap() {
            super(Event.EventType.class);
            for (Event.EventType eventType : Event.EventType.values()) {
                HashMap map = new HashMap();
                this.put(eventType, map);
            }
        }

        public void addListener(String moduleID, EventListener<?> listener) {
            HashMap map = (HashMap)this.get((Object)listener.getType());
            if (!map.containsKey(moduleID)) {
                map.put(moduleID, new ArrayList());
            }
            ((ArrayList)map.get(moduleID)).add(listener);
        }

        public void postEvent(Event event) {
            Profiler.startSection("mpk_event_" + event.getType().name());
            ((HashMap)this.get((Object)event.getType())).forEach((moduleID, listeners) -> listeners.forEach((? super E listener) -> {
                try {
                    listener.run(event);
                }
                catch (Exception e) {
                    API.LOGGER.info("Caught exception from module: " + moduleID + " during Event: " + event.getType().name(), (Throwable)e);
                }
            }));
            Profiler.endSection();
        }
    }
}

