/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.MPKGuiScreen;
import io.github.kurrycat.mpkmod.gui.components.AnglePath;
import io.github.kurrycat.mpkmod.gui.components.BarrierDisplayComponent;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.Component;
import io.github.kurrycat.mpkmod.gui.components.InfoLabel;
import io.github.kurrycat.mpkmod.gui.components.InputHistory;
import io.github.kurrycat.mpkmod.gui.components.KeyBindingLabel;
import io.github.kurrycat.mpkmod.gui.components.Last45Plot;
import io.github.kurrycat.mpkmod.gui.components.MessageQueue;
import io.github.kurrycat.mpkmod.gui.components.MessageReceiver;
import io.github.kurrycat.mpkmod.gui.components.Pane;
import io.github.kurrycat.mpkmod.gui.components.PaneHolder;
import io.github.kurrycat.mpkmod.gui.components.PopupMenu;
import io.github.kurrycat.mpkmod.gui.interfaces.KeyInputListener;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseInputListener;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseScrollListener;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.MainGuiScreen;
import io.github.kurrycat.mpkmod.util.BoundingBox2D;
import io.github.kurrycat.mpkmod.util.ItrUtil;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class ComponentScreen
extends MPKGuiScreen
implements PaneHolder,
MouseInputListener,
MouseScrollListener,
KeyInputListener,
MessageReceiver {
    public ArrayList<Pane<?>> openPanes = new ArrayList();
    public ArrayList<Component> movableComponents = new ArrayList();
    public Set<Component> selected = new HashSet<Component>();
    public Set<Component> holding = new HashSet<Component>();
    public Set<Component> highlighted = new HashSet<Component>();
    private Vector2D lastClickedPos = null;
    private Component lastClicked = null;
    private Vector2D holdingSetPosOffset = null;

    @Override
    public void postMessage(String receiverID, String content, boolean highlighted) {
        MessageQueue q = MessageQueue.getReceiverFor(receiverID, ItrUtil.getAllOfType(MessageQueue.class, this.movableComponents));
        if (q != null) {
            q.postMessage(content, highlighted);
        }
    }

    @Override
    public void onGuiInit() {
        super.onGuiInit();
        this.movableComponents.clear();
        this.components.clear();
        this.selected.clear();
        this.holding.clear();
        this.highlighted.clear();
        this.lastClicked = null;
        this.lastClickedPos = null;
        this.holdingSetPosOffset = null;
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
        this.movableComponents.forEach(c -> c.setSelected(false));
        this.movableComponents.forEach(c -> c.setHighlighted(false));
        this.selected.clear();
        this.holding.clear();
        this.highlighted.clear();
    }

    @Override
    public void onKeyEvent(int keyCode, int scanCode, int modifiers, boolean isCharTyped) {
        super.onKeyEvent(keyCode, keyCode, modifiers, isCharTyped);
        if (this.handleKeyInput(keyCode, scanCode, modifiers, isCharTyped)) {
            return;
        }
        if (!isCharTyped && !this.selected.isEmpty()) {
            Vector2D arrowKeyMove = Vector2D.ZERO;
            switch (keyCode) {
                case 263: {
                    arrowKeyMove = Vector2D.LEFT;
                    break;
                }
                case 262: {
                    arrowKeyMove = Vector2D.RIGHT;
                    break;
                }
                case 265: {
                    arrowKeyMove = Vector2D.UP;
                    break;
                }
                case 264: {
                    arrowKeyMove = Vector2D.DOWN;
                }
            }
            BoundingBox2D containingSelected = this.boundingBoxContainingAll(new ArrayList<Component>(this.selected));
            Vector2D toMove = arrowKeyMove.constrain(Vector2D.ZERO.sub(containingSelected.getMin()), this.getDisplayedSize().sub(containingSelected.getMax()));
            this.selected.forEach(c -> c.addPos(toMove));
        }
    }

    @Override
    public void onMouseClicked(Vector2D mouse, int mouseButton) {
        super.onMouseClicked(mouse, mouseButton);
        if (this.handleMouseInput(Mouse.State.DOWN, mouse, Mouse.Button.fromInt(mouseButton))) {
            return;
        }
        if (this.movableComponents.isEmpty()) {
            return;
        }
        if (Mouse.Button.LEFT.equals(mouseButton)) {
            Component clicked;
            this.highlighted.clear();
            this.lastClickedPos = mouse;
            this.lastClicked = clicked = this.findFirstContainPos(this.lastClickedPos);
            if (clicked != null) {
                this.holding.clear();
                if (this.selected.contains(clicked)) {
                    this.holding.addAll(this.selected);
                }
                this.selected.add(clicked);
                this.holding.add(clicked);
            }
        } else if (Mouse.Button.RIGHT.equals(mouseButton)) {
            this.highlighted.clear();
            if (this.lastClickedPos != null && this.lastClicked == null) {
                this.lastClickedPos = null;
            }
            Component clicked = this.findFirstContainPos(mouse);
            if (this.selected.size() <= 1 && clicked != null) {
                this.highlighted.add(clicked);
                PopupMenu menu = clicked.getPopupMenu();
                if (menu != null) {
                    Vector2D windowSize = this.getScreenSize();
                    Vector2D cPos = clicked.getDisplayedPos();
                    Vector2D cSize = clicked.getDisplayedSize();
                    this.openPane(menu, new Vector2D(cPos.getX() + cSize.getX() + menu.getDisplayedSize().getX() + 1.0 < windowSize.getX() ? cPos.getX() + cSize.getX() + 1.0 : cPos.getX() - menu.getDisplayedSize().getX() - 1.0, clicked.getDisplayedPos().getY()));
                }
            } else if (this.selected.size() > 0) {
                this.highlighted.addAll(this.selected);
                this.selected.clear();
                PopupMenu menu = new PopupMenu();
                menu.addComponent(new Button("Delete", b -> {
                    if (b != Mouse.Button.LEFT) {
                        return;
                    }
                    for (Component c : this.highlighted) {
                        ((MainGuiScreen)menu.paneHolder).removeComponent(c);
                    }
                    menu.close();
                }));
                this.openPane(menu, mouse);
            } else {
                this.highlighted.clear();
                PopupMenu menu = new PopupMenu();
                PopupMenu newLabelMenu = new PopupMenu();
                newLabelMenu.addComponent(new Button("Add InfoLabel", b -> {
                    if (b != Mouse.Button.LEFT) {
                        return;
                    }
                    InfoLabel infoLabel = new InfoLabel("Example Label");
                    infoLabel.setPos(mouse);
                    this.addComponent(infoLabel);
                    menu.close();
                }));
                newLabelMenu.addComponent(new Button("Add KeyBindingLabel", b -> {
                    if (b != Mouse.Button.LEFT) {
                        return;
                    }
                    KeyBindingLabel keyBindingLabel = new KeyBindingLabel(mouse, new Vector2D(20.0, 20.0), "key.forward");
                    this.addComponent(keyBindingLabel);
                    menu.close();
                }));
                newLabelMenu.addComponent(new Button("Add MessageQueue", b -> {
                    if (b != Mouse.Button.LEFT) {
                        return;
                    }
                    MessageQueue messageQueue = new MessageQueue("Example MessageQueue");
                    messageQueue.setPos(mouse);
                    messageQueue.setSize(new Vector2D(30.0, 22.0));
                    this.addComponent(messageQueue);
                    menu.close();
                }));
                newLabelMenu.addComponent(new Button("Add BarrierDisplay", b -> {
                    if (b != Mouse.Button.LEFT) {
                        return;
                    }
                    BarrierDisplayComponent barrierDisplay = new BarrierDisplayComponent();
                    barrierDisplay.setPos(mouse);
                    barrierDisplay.setSize(new Vector2D(30.0, 30.0));
                    this.addComponent(barrierDisplay);
                    menu.close();
                }));
                newLabelMenu.addComponent(new Button("Add InputHistory", b -> {
                    if (b != Mouse.Button.LEFT) {
                        return;
                    }
                    InputHistory inputHistory = new InputHistory();
                    inputHistory.setPos(mouse);
                    inputHistory.setSize(new Vector2D(InputHistory.preferredWidth, 120.0));
                    this.addComponent(inputHistory);
                    menu.close();
                }));
                newLabelMenu.addComponent(new Button("Add Plot (WIP)", b -> {
                    if (b != Mouse.Button.LEFT) {
                        return;
                    }
                    Last45Plot plot = new Last45Plot();
                    plot.setPos(mouse);
                    plot.setSize(new Vector2D(40.0, 40.0));
                    this.addComponent(plot);
                    menu.close();
                }));
                newLabelMenu.addComponent(new Button("Add Angle path (WIP)", b -> {
                    if (b != Mouse.Button.LEFT) {
                        return;
                    }
                    AnglePath path = new AnglePath(false);
                    path.setPos(mouse);
                    path.setSize(new Vector2D(40.0, 40.0));
                    this.addComponent(path);
                    menu.close();
                }));
                menu.addSubMenu(new Button("Add Label"), newLabelMenu);
                this.openPane(menu, mouse);
            }
        }
    }

    @Override
    public void onMouseClickMove(Vector2D mouse, int mouseButton, long timeSinceLastClick) {
        super.onMouseClickMove(mouse, mouseButton, timeSinceLastClick);
        if (this.handleMouseInput(Mouse.State.DRAG, mouse, Mouse.Button.fromInt(mouseButton))) {
            return;
        }
        if (this.movableComponents.isEmpty()) {
            return;
        }
        this.selected = this.selected.stream().filter(c -> this.holding.contains(c)).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public void onMouseReleased(Vector2D mouse, int mouseButton) {
        super.onMouseReleased(mouse, mouseButton);
        if (this.handleMouseInput(Mouse.State.UP, mouse, Mouse.Button.fromInt(mouseButton))) {
            return;
        }
        if (this.movableComponents.isEmpty()) {
            return;
        }
        if (Mouse.Button.LEFT.equals(mouseButton) && this.lastClickedPos != null) {
            boolean moved;
            boolean bl = moved = this.lastClickedPos.sub(mouse).lengthSqr() > 9.0;
            if (!moved && this.lastClicked != null) {
                this.selected.clear();
                this.selected.add(this.lastClicked);
            }
            if (this.holdingSetPosOffset != null) {
                for (Component c : this.holding) {
                    c.setRenderOffset(Vector2D.ZERO);
                    c.addPos(this.holdingSetPosOffset);
                }
            }
            this.holding.clear();
            this.holdingSetPosOffset = null;
            if (this.lastClickedPos != null && this.lastClicked == null) {
                this.selected.clear();
                this.selected.addAll(this.overlap(new Vector2D(Math.min(this.lastClickedPos.getX(), mouse.getX()), Math.min(this.lastClickedPos.getY(), mouse.getY())), new Vector2D(Math.max(this.lastClickedPos.getX(), mouse.getX()), Math.max(this.lastClickedPos.getY(), mouse.getY()))));
            }
            this.lastClickedPos = null;
            this.lastClicked = null;
        }
    }

    @Override
    public void onMouseScroll(Vector2D mousePos, int delta) {
        this.handleMouseScroll(mousePos, delta);
    }

    @Override
    public boolean handleMouseScroll(Vector2D mousePos, int delta) {
        if (!this.openPanes.isEmpty()) {
            this.openPanes.get(this.openPanes.size() - 1).handleMouseScroll(mousePos, delta);
        }
        return ItrUtil.orMap(ItrUtil.getAllOfType(MouseScrollListener.class, this.components, this.movableComponents), b -> b.handleMouseScroll(mousePos, delta));
    }

    @Override
    public void render(Vector2D mouse, float partialTicks) {
        if (this.openPanes.isEmpty() || this.openPanes.get(this.openPanes.size() - 1) instanceof PopupMenu) {
            this.drawDefaultBackground();
        }
        Vector2D hoverMousePos = this.openPanes.isEmpty() ? mouse : new Vector2D(-1.0, -1.0);
        this.movableComponents.forEach(c -> c.setSelected(this.selected.contains(c)));
        this.movableComponents.forEach(c -> c.setHighlighted(this.highlighted.contains(c)));
        for (Component component : this.movableComponents) {
            if (this.holding.contains(component)) {
                Vector2D offset = component.getRenderOffset();
                component.setRenderOffset(Vector2D.ZERO);
                component.render(hoverMousePos);
                component.setRenderOffset(offset);
                continue;
            }
            component.render(hoverMousePos);
        }
        for (Component b : this.components) {
            b.render(hoverMousePos);
        }
        if (!this.holding.isEmpty()) {
            BoundingBox2D containingHolding = this.boundingBoxContainingAll(new ArrayList<Component>(this.holding));
            Vector2D toMove = mouse.sub(this.lastClickedPos);
            this.holdingSetPosOffset = toMove = toMove.constrain(containingHolding.getMin().mult(-1.0), this.getScreenSize().sub(containingHolding.getMax()));
            for (Component component : this.holding) {
                component.setRenderOffset(toMove);
                component.render(hoverMousePos);
            }
        }
        if (this.lastClickedPos != null && this.lastClicked == null && !mouse.equals(this.lastClickedPos)) {
            Vector2D p = new Vector2D(Math.min(this.lastClickedPos.getX(), mouse.getX()), Math.min(this.lastClickedPos.getY(), mouse.getY()));
            Vector2D s = new Vector2D(Math.max(this.lastClickedPos.getX(), mouse.getX()), Math.max(this.lastClickedPos.getY(), mouse.getY())).sub(p);
            Renderer2D.drawHollowRect(p, s, 1.0, Color.RED);
        }
        if (!this.openPanes.isEmpty()) {
            Pane<?> last = this.openPanes.get(this.openPanes.size() - 1);
            if (!(last instanceof PopupMenu)) {
                this.drawDefaultBackground();
            }
            for (int i = 0; i < this.openPanes.size() - 1; ++i) {
                this.openPanes.get(i).render(Vector2D.OFFSCREEN);
            }
            last.render(mouse);
        }
    }

    public ArrayList<Component> overlap(Vector2D p1, Vector2D p2) {
        return this.movableComponents.stream().filter(c -> {
            Vector2D c1 = c.getDisplayedPos();
            Vector2D c2 = c.getDisplayedPos().add(c.getDisplayedSize());
            if (c1.getX() > p2.getX() || c2.getX() < p1.getX()) {
                return false;
            }
            return !(c1.getY() > p2.getY()) && !(c2.getY() < p1.getY());
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
        if (!this.openPanes.isEmpty()) {
            Pane<?> topPane = this.openPanes.get(this.openPanes.size() - 1);
            topPane.handleMouseInput(state, mousePos, button);
            if (topPane.isLoaded()) {
                return true;
            }
        }
        return ItrUtil.orMap(ItrUtil.getAllOfType(MouseInputListener.class, this.components, this.movableComponents), b -> b.handleMouseInput(state, mousePos, button));
    }

    public Component findFirstContainPos(Vector2D p) {
        ArrayList<Component> containPos = this.findContainPos(p);
        if (containPos.isEmpty()) {
            return null;
        }
        return containPos.get(0);
    }

    @Override
    public <T extends PaneHolder> void openPane(Pane<T> p, Vector2D pos) {
        this.openPanes.add(p);
        p.setPaneHolder(this);
        p.setLoaded(true);
        p.setPos(pos);
        this.cleanupScreen();
    }

    @Override
    public <T extends PaneHolder> void closePane(Pane<T> p) {
        this.openPanes.remove(p);
        if (this.openPanes.isEmpty()) {
            this.highlighted.clear();
        }
        p.setLoaded(false);
    }

    @Override
    public void removeComponent(Component c) {
        this.components.remove(c);
    }

    @Override
    public void addComponent(Component c) {
        this.components.add(c);
    }

    public ArrayList<Component> findContainPos(Vector2D p) {
        return this.movableComponents.stream().filter(c -> c.contains(p)).collect(Collectors.toCollection(ArrayList::new));
    }

    private void cleanupScreen() {
        this.selected.clear();
        this.holding.clear();
        this.lastClicked = null;
        this.lastClickedPos = null;
        this.holdingSetPosOffset = null;
    }

    @Override
    public boolean handleKeyInput(int keyCode, int scanCode, int modifiers, boolean isCharTyped) {
        if (!this.openPanes.isEmpty()) {
            this.openPanes.get(this.openPanes.size() - 1).handleKeyInput(keyCode, scanCode, modifiers, isCharTyped);
        }
        return ItrUtil.orMap(ItrUtil.getAllOfType(KeyInputListener.class, this.components, this.movableComponents), b -> b.handleKeyInput(keyCode, scanCode, modifiers, isCharTyped));
    }

    public BoundingBox2D boundingBoxContainingAll(ArrayList<Component> components) {
        if (components.isEmpty()) {
            return null;
        }
        Vector2D min = null;
        Vector2D max = null;
        for (Component c : components) {
            Vector2D p = c.getDisplayedPos().sub(c.getRenderOffset());
            Vector2D p2 = p.add(c.getDisplayedSize());
            if (min == null) {
                min = new Vector2D(p);
            }
            if (max == null) {
                max = new Vector2D(p.add(c.getDisplayedSize()));
            }
            if (p.getX() < min.getX()) {
                min.setX(p.getX());
            }
            if (p2.getX() > max.getX()) {
                max.setX(p2.getX());
            }
            if (p.getY() < min.getY()) {
                min.setY(p.getY());
            }
            if (!(p2.getY() > max.getY())) continue;
            max.setY(p2.getY());
        }
        return new BoundingBox2D(min, max);
    }

    public <T extends PaneHolder> void openPane(Pane<T> p) {
        this.openPanes.add(p);
        p.setPaneHolder(this);
        p.setLoaded(true);
        this.cleanupScreen();
    }

    public final void closeAllPanes() {
        for (int i = this.openPanes.size() - 1; i >= 0; --i) {
            this.openPanes.get(i).close();
        }
    }
}

