/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui;

import io.github.kurrycat.mpkmod.compatibility.API;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class TickThread
implements Runnable {
    private static final AtomicReference<List<Tickable>> tickables = new AtomicReference();
    private static final AtomicBoolean changed = new AtomicBoolean(false);

    public static void startThread() {
        Thread t = new Thread((Runnable)new TickThread(), "mpkmod GUI Tick Thread");
        t.start();
    }

    public static void setTickables(List<Tickable> tickables) {
        TickThread.tickables.set(tickables);
        changed.set(true);
    }

    @Override
    public void run() {
        API.LOGGER.info("Started GuiTickThread");
        while (!Thread.currentThread().isInterrupted()) {
            if (!changed.get()) continue;
            for (Tickable tickable : tickables.get()) {
                try {
                    tickable.runTick();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            changed.set(false);
        }
    }

    public static interface Tickable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        default public void runTick() {
            Tickable tickable = this;
            synchronized (tickable) {
                this.tick();
            }
        }

        public void tick();
    }
}

