/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.Component;
import io.github.kurrycat.mpkmod.util.Debug;
import io.github.kurrycat.mpkmod.util.MathUtil;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.util.ArrayList;

public abstract class ComponentHolder {
    protected ArrayList<Component> components = new ArrayList();
    protected ComponentHolder parent = null;
    protected boolean absolute = false;
    protected long lastUpdated = 0L;
    protected Vector2D pos = Vector2D.ZERO.copy();
    protected Vector2D cpos = Vector2D.ZERO.copy();
    protected Vector2D size = Vector2D.ZERO.copy();
    protected Vector2D csize = Vector2D.ZERO.copy();
    protected int percentFlag = 0;
    protected Anchor parentAnchor = Anchor.TOP_LEFT;
    protected Anchor anchor = Anchor.TOP_LEFT;
    private ComponentHolder root = null;
    private ComponentHolder minX = null;
    private ComponentHolder minY = null;
    private ComponentHolder maxX = null;
    private ComponentHolder maxY = null;

    private long getLastUpdated() {
        if (this.rParent() == null) {
            return this.lastUpdated;
        }
        long updated = Math.max(this.lastUpdated, this.rParent().getLastUpdated());
        if (this.minX != null) {
            updated = Math.max(updated, this.minX.getLastUpdated());
        }
        if (this.maxX != null) {
            updated = Math.max(updated, this.maxX.getLastUpdated());
        }
        if (this.minY != null) {
            updated = Math.max(updated, this.minY.getLastUpdated());
        }
        if (this.maxY != null) {
            updated = Math.max(updated, this.maxY.getLastUpdated());
        }
        return updated;
    }

    public ComponentHolder getRoot() {
        return this.root;
    }

    public void setRoot(ComponentHolder root) {
        this.root = root;
    }

    public Vector2D getDisplayedPos() {
        if (this.parent != null && this.parent.getLastUpdated() > this.lastUpdated || this.root != null && this.root.getLastUpdated() > this.lastUpdated) {
            this.updatePosAndSize();
        }
        return this.cpos;
    }

    public void updatePosAndSize() {
        ComponentHolder p;
        if (this.parent != null) {
            this.root = this.parent.root;
        }
        if ((p = this.rParent()) == null || p == this) {
            this.csize.set(this.size);
            this.cpos.set(this.pos);
            this.lastUpdated = System.nanoTime();
            return;
        }
        double pX = p.getDisplayedPos().getX();
        double pY = p.getDisplayedPos().getY();
        double pW = p.getDisplayedSize().getX();
        double pH = p.getDisplayedSize().getY();
        double w = this.size.getX();
        double h = this.size.getY();
        this.csize.set(PERCENT.HAS_SIZE_X(this.percentFlag) ? pW * w : (w >= 0.0 ? w : pW + w), PERCENT.HAS_SIZE_Y(this.percentFlag) ? pH * h : (h >= 0.0 ? h : pH + h));
        this.cpos.set(pX + this.parentAnchor.origin.getX() * pW + this.pos.getX() * (PERCENT.HAS_POS_X(this.percentFlag) ? pW : 1.0) * this.parentAnchor.multiplier.getX() - this.anchor.origin.getX() * this.csize.getX(), pY + this.parentAnchor.origin.getY() * pH + this.pos.getY() * (PERCENT.HAS_POS_Y(this.percentFlag) ? pH : 1.0) * this.parentAnchor.multiplier.getY() - this.anchor.origin.getY() * this.csize.getY());
        if (this.minX == null && this.maxX == null && this.minY == null && this.maxY == null) {
            this.lastUpdated = System.nanoTime();
            return;
        }
        if (this.minX != null || this.maxX != null) {
            double oldPX = pX;
            if (this.minX != null) {
                pX = this.minX.getDisplayedPos().getX() + this.minX.getDisplayedSize().getX();
            }
            double d = pW = this.maxX == null ? oldPX + pW - pX : this.maxX.getDisplayedPos().getX() - pX;
        }
        if (this.minY != null || this.maxY != null) {
            double oldPY = pY;
            if (this.minY != null) {
                pY = this.minY.getDisplayedPos().getY() + this.minY.getDisplayedSize().getY();
            }
            double d = pH = this.maxY == null ? oldPY + pH - pY : this.maxY.getDisplayedPos().getY() - pY;
        }
        this.csize.set(PERCENT.HAS_SIZE_X(this.percentFlag) ? pW * w : (w >= 0.0 ? w : pW + w), PERCENT.HAS_SIZE_Y(this.percentFlag) ? pH * h : (h >= 0.0 ? h : pH + h));
        this.cpos.set(pX + this.parentAnchor.origin.getX() * pW + this.pos.getX() * (PERCENT.HAS_POS_X(this.percentFlag) ? pW : 1.0) * this.parentAnchor.multiplier.getX() - this.anchor.origin.getX() * this.csize.getX(), pY + this.parentAnchor.origin.getY() * pH + this.pos.getY() * (PERCENT.HAS_POS_Y(this.percentFlag) ? pH : 1.0) * this.parentAnchor.multiplier.getY() - this.anchor.origin.getY() * this.csize.getY());
        this.lastUpdated = System.nanoTime();
    }

    protected ComponentHolder rParent() {
        return this.absolute ? this.root : this.parent;
    }

    public Vector2D getDisplayedSize() {
        if (this.parent != null && this.parent.getLastUpdated() > this.lastUpdated || this.root != null && this.root.getLastUpdated() > this.lastUpdated) {
            this.updatePosAndSize();
        }
        return this.csize;
    }

    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }

    public void setSize(Vector2D size) {
        if (this.size.equals(size)) {
            return;
        }
        this.size.set(PERCENT.HAS_SIZE_X(this.percentFlag) ? MathUtil.constrain01(size.getX()) : size.getX(), PERCENT.HAS_SIZE_Y(this.percentFlag) ? MathUtil.constrain01(size.getY()) : size.getY());
        this.updatePosAndSize();
    }

    public void setHeight(double h, boolean percent) {
        if (this.size.getY() == h && percent == PERCENT.HAS_SIZE_Y(this.percentFlag)) {
            return;
        }
        this.percentFlag = PERCENT.SET_SIZE_Y(this.percentFlag, percent);
        this.size.setY(PERCENT.HAS_SIZE_Y(this.percentFlag) ? MathUtil.constrain01(h) : h);
        this.updatePosAndSize();
    }

    public void setWidth(double w, boolean percent) {
        if (this.size.getX() == w && percent == PERCENT.HAS_SIZE_X(this.percentFlag)) {
            return;
        }
        this.percentFlag = PERCENT.SET_SIZE_X(this.percentFlag, percent);
        this.size.setX(PERCENT.HAS_SIZE_X(this.percentFlag) ? MathUtil.constrain01(w) : w);
        this.updatePosAndSize();
    }

    public void addSize(Vector2D offset) {
        Vector2D transformed = this.parentAnchor.transformVec(offset);
        if (this.rParent() != null) {
            if (PERCENT.HAS_SIZE_X(this.percentFlag)) {
                transformed.setX(transformed.getX() / this.rParent().getDisplayedSize().getX());
            }
            if (PERCENT.HAS_SIZE_Y(this.percentFlag)) {
                transformed.setY(transformed.getY() / this.rParent().getDisplayedSize().getY());
            }
        }
        this.setSize(this.size.add(transformed));
    }

    public void addPos(Vector2D offset) {
        Vector2D transformed = this.parentAnchor.transformVec(offset);
        if (this.rParent() != null) {
            if (PERCENT.HAS_POS_X(this.percentFlag)) {
                transformed.setX(transformed.getX() / this.rParent().getDisplayedSize().getX());
            }
            if (PERCENT.HAS_POS_Y(this.percentFlag)) {
                transformed.setY(transformed.getY() / this.rParent().getDisplayedSize().getY());
            }
        }
        this.setPos(this.pos.add(transformed));
    }

    public void setCPos(Vector2D pos) {
        this.cpos.set(pos);
    }

    public void setPos(Vector2D pos) {
        if (this.pos.equals(pos)) {
            return;
        }
        if (PERCENT.HAS_POS_X(this.percentFlag) && MathUtil.constrain01(pos.getX()) != pos.getX() || PERCENT.HAS_POS_Y(this.percentFlag) && MathUtil.constrain01(pos.getY()) != pos.getY()) {
            Debug.stacktrace("Warning: position not in range 0 - 1 even though percent flag is true for this field");
        }
        this.pos.set(PERCENT.HAS_POS_X(this.percentFlag) ? MathUtil.constrain01(pos.getX()) : pos.getX(), PERCENT.HAS_POS_Y(this.percentFlag) ? MathUtil.constrain01(pos.getY()) : pos.getY());
        this.updatePosAndSize();
    }

    public void addChild(Component child) {
        this.addChild(child, 0, Anchor.TOP_LEFT);
    }

    public void addChild(Component child, int percentFlag) {
        this.addChild(child, percentFlag, Anchor.TOP_LEFT);
    }

    public void addChild(Component child, int percentFlag, Anchor anchor) {
        this.addChild(child, percentFlag, anchor, anchor);
    }

    public void addChild(Component child, int percentFlag, Anchor anchor, Anchor parentAnchor) {
        this.passPositionTo(child, percentFlag, anchor, parentAnchor);
        this.components.add(child);
    }

    public void passPositionTo(ComponentHolder child, int percentFlag, Anchor anchor, Anchor parentAnchor) {
        child.parentAnchor = parentAnchor;
        child.anchor = anchor;
        this.passPositionTo(child, percentFlag);
    }

    public void passPositionTo(ComponentHolder child, int percentFlag) {
        child.percentFlag = percentFlag;
        this.passPositionTo(child);
    }

    public void passPositionTo(ComponentHolder child) {
        child.setParent(this);
        child.updatePosAndSize();
    }

    public void setParent(ComponentHolder parent) {
        this.root = parent.root;
        this.parent = parent;
    }

    public void stretchXBetween(ComponentHolder child, ComponentHolder min, ComponentHolder max) {
        child.minX = min;
        child.maxX = max;
        this.passPositionTo(child);
    }

    public void stretchYBetween(ComponentHolder child, ComponentHolder min, ComponentHolder max) {
        child.minY = min;
        child.maxY = max;
        this.passPositionTo(child);
    }

    public void passPositionTo(ComponentHolder child, int percentFlag, Anchor anchor) {
        this.passPositionTo(child, percentFlag, anchor, anchor);
    }

    public void removeChild(Component child) {
        this.components.remove(child);
        child.setRoot(null);
        child.parent = null;
    }

    public static class PERCENT {
        public static final int NONE = 0;
        public static final int POS_X = 1;
        public static final int POS_Y = 2;
        public static final int SIZE_X = 4;
        public static final int SIZE_Y = 8;
        public static final int ALL = 15;
        public static final int POS = 3;
        public static final int SIZE = 12;
        public static final int X = 5;
        public static final int Y = 10;

        public static boolean HAS_POS_X(int flag) {
            return (flag & 1) != 0;
        }

        public static int SET_POS_X(int flag, boolean state) {
            flag &= 0xFFFFFFFE;
            if (state) {
                flag |= 1;
            }
            return flag;
        }

        public static boolean HAS_POS_Y(int flag) {
            return (flag & 2) != 0;
        }

        public static int SET_POS_Y(int flag, boolean state) {
            flag &= 0xFFFFFFFD;
            if (state) {
                flag |= 2;
            }
            return flag;
        }

        public static boolean HAS_SIZE_X(int flag) {
            return (flag & 4) != 0;
        }

        public static int SET_SIZE_X(int flag, boolean state) {
            flag &= 0xFFFFFFFB;
            if (state) {
                flag |= 4;
            }
            return flag;
        }

        public static boolean HAS_SIZE_Y(int flag) {
            return (flag & 8) != 0;
        }

        public static int SET_SIZE_Y(int flag, boolean state) {
            flag &= 0xFFFFFFF7;
            if (state) {
                flag |= 8;
            }
            return flag;
        }
    }
}

