/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.components.Component;
import io.github.kurrycat.mpkmod.gui.interfaces.KeyInputListener;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseInputListener;
import io.github.kurrycat.mpkmod.util.MathUtil;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;

public class InputField
extends Component
implements KeyInputListener,
MouseInputListener {
    public static final double HEIGHT = 11.0;
    public static String FILTER_ALL = "[0-9a-zA-Z!?,.:;\\-{}()/&%$\"<>' ]";
    public static String FILTER_NUMBERS = "[0-9.,\\-!]";
    public static String FILTER_HEX = "[#0-9a-fA-F]";
    public static String FILTER_FILENAME = "[^</*?\"\\\\>:|]";
    public boolean numbersOnly;
    public String content;
    public ContentProvider onContentChange = null;
    public String name = null;
    public Color normalColor = new Color(31, 31, 31, 150);
    public Color edgeColor = new Color(255, 255, 255, 95);
    public Color cursorColor = new Color(255, 255, 255, 150);
    public Color highlightColor = new Color(255, 255, 255, 175);
    private boolean isFocused = false;
    private int cursorPos = 0;
    private int highlightStart = 0;
    private int highlightEnd = 0;
    private String customFilter = null;

    public InputField(Vector2D pos, double width) {
        this("", pos, width, false);
    }

    public InputField(String content, Vector2D pos, double width, boolean numbersOnly) {
        this.setPos(pos);
        this.setSize(new Vector2D(width, 11.0));
        this.content = content;
        this.numbersOnly = numbersOnly;
    }

    public InputField(String content, Vector2D pos, double width) {
        this(content, pos, width, false);
    }

    public void focus() {
        this.isFocused = true;
    }

    public InputField setName(String name) {
        this.name = name;
        return this;
    }

    public InputField setOnContentChange(ContentProvider onContentChange) {
        this.onContentChange = onContentChange;
        return this;
    }

    @Override
    public void render(Vector2D mouse) {
        Vector2D nameSize = this.name == null ? Vector2D.ZERO : FontRenderer.getStringSize(this.name);
        Vector2D rectPos = this.getDisplayedPos().add(nameSize.getX(), 0.0);
        Vector2D rectSize = this.getDisplayedSize().sub(nameSize.getX(), 0.0);
        if (this.name != null) {
            FontRenderer.drawCenteredString(this.name, this.getDisplayedPos().add(nameSize.getX() / 2.0, this.getDisplayedSize().getY() / 2.0 + 1.0), Color.WHITE, false);
        }
        Renderer2D.drawRectWithEdge(rectPos, rectSize, 1.0, this.normalColor, this.edgeColor);
        this.cursorPos = MathUtil.constrain(this.cursorPos, 0, this.content.length());
        this.highlightStart = MathUtil.constrain(this.highlightStart, 0, this.content.length());
        this.highlightEnd = MathUtil.constrain(this.highlightEnd, 0, this.content.length());
        FontRenderer.drawString(this.content.substring(0, this.highlightStart), rectPos.add(2.0, 2.0), Color.WHITE, false);
        if (this.highlightStart != this.highlightEnd) {
            Renderer2D.drawRect(rectPos.add(2.0 + FontRenderer.getStringSize(this.content.substring(0, this.highlightStart)).getX(), 2.0), new Vector2D(FontRenderer.getStringSize(this.content.substring(this.highlightStart, this.highlightEnd)).getX(), rectSize.getY() - 4.0), this.highlightColor);
        }
        FontRenderer.drawString(this.content.substring(this.highlightStart, this.highlightEnd), rectPos.add(2.0 + FontRenderer.getStringSize(this.content.substring(0, this.highlightStart)).getX(), 2.0), Color.BLACK, false);
        FontRenderer.drawString(this.content.substring(this.highlightEnd), rectPos.add(2.0 + FontRenderer.getStringSize(this.content.substring(0, this.highlightEnd)).getX(), 2.0), Color.WHITE, false);
        if (this.isFocused && this.highlightStart == this.highlightEnd) {
            Renderer2D.drawRect(new Vector2D(rectPos.getX() + this.getCursorX(), rectPos.getY() + 1.0), new Vector2D(1.0, rectSize.getY() - 2.0), this.cursorColor);
        }
    }

    private double getCursorX() {
        return 2.0 + FontRenderer.getStringSize(this.content.substring(0, this.cursorPos)).getX();
    }

    @Override
    public boolean handleKeyInput(int keyCode, int scanCode, int modifiers, boolean isCharTyped) {
        if (!this.isFocused) {
            return false;
        }
        boolean inputPerformed = true;
        if (isCharTyped && String.valueOf((char)keyCode).matches(this.getFilter())) {
            this.typeContentAtCursor(Character.toString((char)keyCode));
        } else {
            switch (keyCode) {
                case 259: {
                    this.deleteSelection();
                    if (this.highlightStart == this.highlightEnd) {
                        --this.cursorPos;
                        break;
                    }
                    this.cursorPos = this.highlightStart;
                    break;
                }
                case 261: {
                    if (this.highlightStart == this.highlightEnd) {
                        ++this.cursorPos;
                    }
                    this.deleteSelection();
                    if (this.highlightStart != this.highlightEnd) break;
                    --this.cursorPos;
                    break;
                }
                case 263: {
                    if (this.highlightStart == this.highlightEnd) {
                        --this.cursorPos;
                        break;
                    }
                    this.cursorPos = this.highlightStart;
                    break;
                }
                case 262: {
                    if (this.highlightStart == this.highlightEnd) {
                        ++this.cursorPos;
                        break;
                    }
                    this.cursorPos = this.highlightEnd;
                    break;
                }
                default: {
                    inputPerformed = false;
                }
            }
        }
        if (inputPerformed) {
            this.highlightStart = this.cursorPos = MathUtil.constrain(this.cursorPos, 0, this.content.length());
            this.highlightEnd = this.cursorPos;
        }
        return true;
    }

    private String getFilter() {
        if (this.customFilter != null) {
            return this.customFilter;
        }
        return this.numbersOnly ? FILTER_NUMBERS : FILTER_ALL;
    }

    public InputField setFilter(String filter) {
        this.customFilter = filter;
        return this;
    }

    public void typeContentAtCursor(String c) {
        this.updateContent(this.content.substring(0, this.highlightStart) + c + this.content.substring(this.highlightEnd));
        this.highlightStart = this.highlightEnd = (this.cursorPos = this.highlightStart + c.length());
    }

    private void deleteSelection() {
        if (this.highlightStart == this.highlightEnd) {
            this.updateContent(this.content.substring(0, Math.max(this.cursorPos - 1, 0)) + (this.cursorPos >= this.content.length() ? "" : this.content.substring(this.cursorPos)));
        } else {
            this.updateContent(this.content.substring(0, this.highlightStart) + this.content.substring(this.highlightEnd));
        }
    }

    private void updateContent(String content) {
        this.content = content;
        if (this.onContentChange != null) {
            this.onContentChange.apply(new Content(content));
        }
    }

    public void clear() {
        this.isFocused = false;
        this.cursorPos = 0;
        this.highlightStart = 0;
        this.highlightEnd = 0;
        this.content = "";
    }

    @Override
    public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
        if (button == Mouse.Button.LEFT) {
            switch (state) {
                case DOWN: {
                    if (this.contains(mousePos)) {
                        this.isFocused = true;
                        this.highlightStart = this.cursorPos = this.getCursorPosFromMousePos(mousePos);
                        this.highlightEnd = this.cursorPos;
                        return true;
                    }
                    this.isFocused = false;
                }
                case DRAG: 
                case UP: {
                    if (!this.isFocused) break;
                    int c = this.getCursorPosFromMousePos(mousePos);
                    if (c < this.cursorPos) {
                        this.highlightStart = c;
                        this.highlightEnd = this.cursorPos;
                    } else {
                        this.highlightStart = this.cursorPos;
                        this.highlightEnd = c;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private int getCursorPosFromMousePos(Vector2D mouse) {
        Vector2D nameSize = this.name == null ? Vector2D.ZERO : FontRenderer.getStringSize(this.name);
        Vector2D rectPos = this.getDisplayedPos().add(nameSize.getX(), 0.0);
        double x = mouse.getX() - rectPos.getX() - 2.0;
        if (x < 0.0) {
            return 0;
        }
        if (x > FontRenderer.getStringSize(this.content).getX()) {
            return this.content.length();
        }
        for (int i = 1; i <= this.content.length(); ++i) {
            int charWidth = FontRenderer.getStringSize(this.content.substring(i - 1, i)).getXI();
            if (x < (double)charWidth / 2.0) {
                return i - 1;
            }
            if (x < (double)charWidth) {
                return i;
            }
            x -= (double)charWidth;
        }
        return this.content.length();
    }

    public static class Content {
        public String content;

        public Content(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        public Double getNumber() {
            try {
                return Double.parseDouble(this.content);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    @FunctionalInterface
    public static interface ContentProvider {
        public void apply(Content var1);
    }
}

