/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.Component;
import io.github.kurrycat.mpkmod.gui.components.Pane;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.MainGuiScreen;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.util.ArrayList;

public class PopupMenu
extends Pane<MainGuiScreen> {
    public ArrayList<PopupMenu> subMenus = new ArrayList();
    private PopupMenu currentlyActive = null;

    public PopupMenu() {
        super(Vector2D.OFFSCREEN, new Vector2D(0.0, 1.0));
        this.components.clear();
    }

    public void addSubMenu(Button button, PopupMenu menu) {
        this.addComponent(button);
        button.setButtonCallback(mouseButton -> {
            if (Mouse.Button.LEFT.equals((Object)mouseButton)) {
                this.currentlyActive = menu;
                menu.setLoaded(true);
            }
        });
        this.subMenus.add(menu);
        this.passPositionTo(menu);
    }

    public void addComponent(Component c) {
        this.addComponent(c, 0);
    }

    public void addComponent(Component c, int percentFlag) {
        c.setPos(new Vector2D(1.0, this.getDisplayedSize().getY()));
        this.addChild(c, percentFlag, Anchor.TOP_LEFT);
        this.setSize(new Vector2D(Math.max(c.getDisplayedSize().getX() + 2.0, this.getDisplayedSize().getX()), this.getDisplayedSize().getY() + c.getDisplayedSize().getY() + 1.0));
        for (Component comp : this.components) {
            comp.setSize(new Vector2D(-2.0, comp.getDisplayedSize().getY()));
        }
    }

    @Override
    public void close() {
        this.subMenus.forEach(m -> m.setLoaded(false));
        this.currentlyActive = null;
        super.close();
    }

    @Override
    public void render(Vector2D mousePos) {
        if (this.currentlyActive == null) {
            super.render(mousePos);
        } else {
            this.currentlyActive.render(mousePos);
        }
    }

    @Override
    public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
        if (this.isLoaded()) {
            if (state == Mouse.State.DOWN && !this.contains(mousePos)) {
                this.close();
                return true;
            }
            if (this.currentlyActive != null) {
                return this.currentlyActive.handleMouseInput(state, mousePos, button);
            }
            return super.handleMouseInput(state, mousePos, button);
        }
        return false;
    }

    @Override
    public boolean handleMouseScroll(Vector2D mousePos, int delta) {
        if (this.currentlyActive != null) {
            return this.currentlyActive.handleMouseScroll(mousePos, delta);
        }
        return super.handleMouseScroll(mousePos, delta);
    }

    @Override
    public boolean handleKeyInput(int keyCode, int scanCode, int modifiers, boolean isCharTyped) {
        if (this.currentlyActive != null) {
            return this.currentlyActive.handleKeyInput(keyCode, scanCode, modifiers, isCharTyped);
        }
        return super.handleKeyInput(keyCode, scanCode, modifiers, isCharTyped);
    }

    @Override
    public boolean contains(Vector2D testPos) {
        if (this.currentlyActive != null) {
            return this.currentlyActive.contains(testPos);
        }
        return super.contains(testPos);
    }
}

