/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.components.Component;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseInputListener;
import io.github.kurrycat.mpkmod.util.BoundingBox2D;
import io.github.kurrycat.mpkmod.util.Line2D;
import io.github.kurrycat.mpkmod.util.MathUtil;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;

public abstract class ResizableComponent
extends Component
implements MouseInputListener {
    private Vector2D minSize = new Vector2D(5.0, 5.0);
    private BoundingBox2D.Edge[] areBeingResized = null;
    private boolean xResizeLocked = false;
    private boolean yResizeLocked = false;

    public Vector2D getMinSize() {
        return this.minSize;
    }

    public ResizableComponent setMinSize(Vector2D minSize) {
        this.minSize = minSize;
        return this;
    }

    @Override
    public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
        if (button == Mouse.Button.LEFT) {
            BoundingBox2D bb = this.getComponentBoundingBox();
            switch (state) {
                case DOWN: {
                    this.areBeingResized = bb.allOnEdge(mousePos, 2.0);
                    if (this.areBeingResized.length != 0) break;
                    this.areBeingResized = null;
                    break;
                }
                case DRAG: {
                    if (this.areBeingResized == null) break;
                    this.resizeAccordingToSavedEdges(mousePos);
                    break;
                }
                case UP: {
                    if (this.areBeingResized == null) break;
                    this.resizeAccordingToSavedEdges(mousePos);
                    this.areBeingResized = null;
                    return true;
                }
            }
            return this.areBeingResized != null;
        }
        return false;
    }

    public BoundingBox2D getComponentBoundingBox() {
        return BoundingBox2D.fromPosSize(this.getDisplayedPos(), this.getDisplayedSize());
    }

    public void resizeAccordingToSavedEdges(Vector2D mousePos) {
        double multiplier;
        double oppositeEdgePos;
        double edgePos;
        Boolean yResizing;
        Boolean xResizing;
        if (this.areBeingResized == null) {
            return;
        }
        BoundingBox2D bb = this.getComponentBoundingBox();
        List<BoundingBox2D.Edge> beingResized = Arrays.asList(this.areBeingResized);
        Boolean bl = beingResized.contains((Object)BoundingBox2D.Edge.LEFT) ? Boolean.FALSE : (xResizing = beingResized.contains((Object)BoundingBox2D.Edge.RIGHT) ? Boolean.TRUE : null);
        Boolean bl2 = beingResized.contains((Object)BoundingBox2D.Edge.TOP) ? Boolean.FALSE : (yResizing = beingResized.contains((Object)BoundingBox2D.Edge.BOTTOM) ? Boolean.TRUE : null);
        if (xResizing != null && !this.xResizeLocked) {
            double mouseX = mousePos.getX();
            edgePos = xResizing != false ? bb.maxX() : bb.minX();
            oppositeEdgePos = xResizing != false ? bb.minX() : bb.maxX();
            mouseX = xResizing != false ? MathUtil.constrain(mouseX, oppositeEdgePos, this.getRoot().getDisplayedSize().getX()) : MathUtil.constrain(mouseX, 0.0, oppositeEdgePos);
            multiplier = xResizing == this.parentAnchor.invertedX ? -1.0 : 1.0;
            this.addSize(new Vector2D((mouseX - edgePos) * multiplier, 0.0));
            if (xResizing == this.anchor.invertedX) {
                this.addPos(new Vector2D(mouseX - edgePos, 0.0));
            }
        }
        if (yResizing != null && !this.yResizeLocked) {
            double mouseY = mousePos.getY();
            edgePos = yResizing != false ? bb.maxY() : bb.minY();
            oppositeEdgePos = yResizing != false ? bb.minY() : bb.maxY();
            mouseY = yResizing != false ? MathUtil.constrain(mouseY, oppositeEdgePos, this.getRoot().getDisplayedSize().getY()) : MathUtil.constrain(mouseY, 0.0, oppositeEdgePos);
            multiplier = yResizing == this.parentAnchor.invertedY ? -1.0 : 1.0;
            this.addSize(new Vector2D(0.0, (mouseY - edgePos) * multiplier));
            if (yResizing == this.anchor.invertedY) {
                this.addPos(new Vector2D(0.0, mouseY - edgePos));
            }
        }
    }

    public void renderHoverEdges(Vector2D mouse) {
        BoundingBox2D bb = this.getComponentBoundingBox();
        BoundingBox2D.Edge[] edges = bb.allOnEdge(mouse, 2.0);
        if (this.areBeingResized != null) {
            edges = this.areBeingResized;
        }
        for (BoundingBox2D.Edge e : edges) {
            Line2D l = e.getLine(bb);
            if (l.p1.getXI() == l.p2.getXI() && this.xResizeLocked || l.p1.getYI() == l.p2.getYI() && this.yResizeLocked) continue;
            BoundingBox2D lineExpandedBB = new BoundingBox2D(l.p1.sub(1.0), l.p2.add(1.0));
            Renderer2D.drawRect(lineExpandedBB.getMin(), lineExpandedBB.getSize(), Color.RED);
        }
    }

    public void setXResizeLocked(boolean xResizeLocked) {
        this.xResizeLocked = xResizeLocked;
    }

    public void setYResizeLocked(boolean yResizeLocked) {
        this.yResizeLocked = yResizeLocked;
    }
}

