/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.infovars;

import io.github.kurrycat.mpkmod.Main;
import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.gui.infovars.InfoTree;
import io.github.kurrycat.mpkmod.gui.infovars.InfoVar;
import io.github.kurrycat.mpkmod.util.ClassUtil;
import io.github.kurrycat.mpkmod.util.Colors;
import io.github.kurrycat.mpkmod.util.Debug;
import io.github.kurrycat.mpkmod.util.FormatDecimals;
import io.github.kurrycat.mpkmod.util.MathUtil;
import io.github.kurrycat.mpkmod.util.StringUtil;
import io.github.kurrycat.mpkmod.util.Tuple;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class InfoString {
    public static final String FORMATTING_REGEX = "\\{(?<varName>.*?)(,(?<decimals>\\d+)(?<keepZeros>!)?)?}";
    public static final Pattern FORMATTING_PATTERN = Pattern.compile("\\{(?<varName>.*?)(,(?<decimals>\\d+)(?<keepZeros>!)?)?}");
    private final String[] textParts;
    private final Provider[] providers;

    public InfoString(String text) {
        String result = text;
        for (Colors c : Colors.values()) {
            result = result.replace("{" + c.getName() + "}", c.getCode());
        }
        Matcher matcher = FORMATTING_PATTERN.matcher(result);
        ArrayList<String> parts = new ArrayList<String>();
        ArrayList<Provider> providerList = new ArrayList<Provider>();
        int lastEnd = 0;
        while (matcher.find()) {
            parts.add(result.substring(lastEnd, matcher.start()));
            String fullMatch = matcher.group();
            String varName = matcher.group("varName");
            int decimals = MathUtil.parseInt(matcher.group("decimals"), 3);
            boolean keepZeros = matcher.group("keepZeros") != null;
            providerList.add(new Provider(fullMatch, varName, decimals, keepZeros));
            parts.add(null);
            lastEnd = matcher.end();
        }
        parts.add(result.substring(lastEnd));
        this.textParts = parts.toArray(new String[0]);
        this.providers = providerList.toArray(new Provider[0]);
    }

    public static Object getObj(List<Object> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        Object obj = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            if (obj == null) {
                return null;
            }
            Object o = list.get(i);
            if (o instanceof Method) {
                try {
                    obj = ((Method)o).invoke(obj, new Object[0]);
                    continue;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    API.LOGGER.info(API.CONFIG_MARKER, "InfoMap: IllegalAccessException while trying to access method {} from {}", new Object[]{((Method)o).getName(), obj.getClass().getName()});
                    Debug.stacktrace();
                    return null;
                }
            }
            if (!(o instanceof java.lang.reflect.Field)) continue;
            try {
                obj = ((java.lang.reflect.Field)o).get(obj);
                continue;
            }
            catch (IllegalAccessException e) {
                API.LOGGER.info(API.CONFIG_MARKER, "InfoMap: IllegalAccessException while trying to access field {} from {}", new Object[]{((java.lang.reflect.Field)o).getName(), obj.getClass().getName()});
                Debug.stacktrace();
                return null;
            }
        }
        return obj;
    }

    public static InfoTree createInfoTree() {
        InfoTree infoMap = new InfoTree();
        HashMap accessInstances = new HashMap();
        List<Tuple<AccessInstance, java.lang.reflect.Field>> accessInstanceAnnotations = ClassUtil.getFieldAnnotations(AccessInstance.class);
        for (Tuple<AccessInstance, java.lang.reflect.Field> tuple : accessInstanceAnnotations) {
            java.lang.reflect.Field field = tuple.getSecond();
            Class<?> accessClass = field.getDeclaringClass();
            accessInstances.put(accessClass, Arrays.asList(accessClass, field));
        }
        List<Tuple<AccessInstance, Class<?>>> accessClassAnnotations = ClassUtil.getClassAnnotations(AccessInstance.class);
        for (Tuple<AccessInstance, Class<?>> tuple : accessClassAnnotations) {
            Class<?> clazz = tuple.getSecond();
            accessInstances.put(clazz, Collections.singletonList(clazz));
        }
        List<Tuple<DataClass, Class<?>>> list = ClassUtil.getClassAnnotations(DataClass.class);
        List<Class<?>> list2 = list.stream().map(Tuple::getSecond).collect(Collectors.toList());
        ArrayList accessClassList = new ArrayList(accessInstances.keySet());
        List<Tuple<Field, java.lang.reflect.Field>> fieldAnnotations = ClassUtil.getFieldAnnotations(accessClassList, Field.class);
        for (Tuple<Field, java.lang.reflect.Field> t : fieldAnnotations) {
            java.lang.reflect.Field f = t.getSecond();
            Class<?> clazz = f.getDeclaringClass();
            String name = f.getName();
            ArrayList<Object> objects = new ArrayList<Object>((Collection)accessInstances.get(clazz));
            objects.add(f);
            InfoVar var = new InfoVar(name, objects);
            infoMap.addElement(name, var);
            if (!list2.contains(f.getType())) continue;
            InfoString.recursiveSearch(var, objects, list2);
        }
        List<Tuple<Getter, Method>> methodAnnotations = ClassUtil.getMethodAnnotations(accessClassList, Getter.class);
        for (Tuple<Getter, Method> t : methodAnnotations) {
            Method m = t.getSecond();
            Class<?> clazz = m.getDeclaringClass();
            String name = StringUtil.getterName(m.getName());
            ArrayList<Object> objects = new ArrayList<Object>((Collection)accessInstances.get(clazz));
            objects.add(m);
            InfoVar var = new InfoVar(name, objects);
            infoMap.addElement(name, var);
            if (!list2.contains(m.getReturnType())) continue;
            InfoString.recursiveSearch(var, objects, list2);
        }
        return infoMap;
    }

    private static void recursiveSearch(InfoVar parentVar, List<Object> parent, List<Class<?>> dataClassList) {
        if (parent.size() == 0) {
            return;
        }
        Object lastParent = parent.get(parent.size() - 1);
        Class<?> lastParentType = InfoString.getParentType(lastParent);
        if (lastParentType == null) {
            return;
        }
        List<Tuple<Field, java.lang.reflect.Field>> fieldAnnotations = ClassUtil.getFieldAnnotations(Collections.singletonList(lastParentType), Field.class);
        for (Tuple<Field, java.lang.reflect.Field> t : fieldAnnotations) {
            java.lang.reflect.Field f = t.getSecond();
            String name = f.getName();
            ArrayList<Object> objects = new ArrayList<Object>(parent);
            objects.add(f);
            InfoVar var = parentVar.createChild(name, objects);
            if (!dataClassList.contains(f.getType()) || parent.contains(f)) continue;
            InfoString.recursiveSearch(var, objects, dataClassList);
        }
        List<Tuple<Getter, Method>> methodAnnotations = ClassUtil.getMethodAnnotations(Collections.singletonList(lastParentType), Getter.class);
        for (Tuple<Getter, Method> t : methodAnnotations) {
            Method m = t.getSecond();
            String name = StringUtil.getterName(m.getName());
            ArrayList<Object> objects = new ArrayList<Object>(parent);
            objects.add(m);
            InfoVar var = parentVar.createChild(name, objects);
            if (!dataClassList.contains(m.getReturnType()) || parent.contains(m)) continue;
            InfoString.recursiveSearch(var, objects, dataClassList);
        }
    }

    private static Class<?> getParentType(Object parent) {
        Class<?> parentType = null;
        if (parent instanceof Method) {
            parentType = ((Method)parent).getReturnType();
        } else if (parent instanceof java.lang.reflect.Field) {
            parentType = ((java.lang.reflect.Field)parent).getType();
        }
        return parentType;
    }

    public String get() {
        StringBuilder sb = new StringBuilder();
        int j = 0;
        for (int i = 0; i < this.textParts.length; ++i) {
            if (this.textParts[i] != null) {
                sb.append(this.textParts[i]);
                continue;
            }
            sb.append(this.providers[j].get());
            ++j;
        }
        return sb.toString();
    }

    private static class Provider {
        private final String fullMatch;
        private final String varName;
        private final int decimals;
        private final boolean keepZeros;
        private final InfoVar infoVar;

        public Provider(String fullMatch, String varName, int decimals, boolean keepZeros) {
            this.fullMatch = fullMatch;
            this.varName = varName;
            this.decimals = decimals;
            this.keepZeros = keepZeros;
            this.infoVar = Main.infoTree.getElement(this.varName);
        }

        public String get() {
            if (this.infoVar == null) {
                return this.fullMatch;
            }
            Object o = this.infoVar.getObj();
            if (o == null) {
                return this.fullMatch;
            }
            if (o instanceof Double) {
                return MathUtil.formatDecimals((Double)o, this.decimals, this.keepZeros);
            }
            if (o instanceof Float) {
                return MathUtil.formatDecimals(((Float)o).floatValue(), this.decimals, this.keepZeros);
            }
            if (o instanceof FormatDecimals) {
                return ((FormatDecimals)o).formatDecimals(this.decimals, this.keepZeros);
            }
            if (o.toString().equals(o.getClass().getName() + "@" + Integer.toHexString(o.hashCode()))) {
                return "[" + o.getClass().getSimpleName() + " object]";
            }
            return o.toString();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface DataClass {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface AccessInstance {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Getter {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Field {
    }
}

