/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.screens.main_gui;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.Theme;
import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.InputField;
import io.github.kurrycat.mpkmod.gui.components.Pane;
import io.github.kurrycat.mpkmod.gui.components.ScrollableList;
import io.github.kurrycat.mpkmod.gui.components.ScrollableListItem;
import io.github.kurrycat.mpkmod.gui.components.TextRectangle;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.LabelConfiguration;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.MainGuiScreen;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LoadConfigPane
extends Pane<MainGuiScreen> {
    public static Color edgeColor = Theme.lightEdge;
    private InputField filename;
    private ConfigFileList presets;
    private ConfigFileList savedConfigs;

    public LoadConfigPane(Vector2D pos, Vector2D size) {
        super(pos, size);
        this.backgroundColor = new Color(16, 16, 16, 70);
        this.initComponents();
    }

    private void initComponents() {
        this.filename = new InputField("", new Vector2D(0.0, 0.3333333333333333), 0.9);
        this.filename.setFilter(InputField.FILTER_FILENAME);
        this.filename.setOnContentChange(content -> {
            this.presets.updateItems();
            this.savedConfigs.updateItems();
        });
        TextRectangle r = new TextRectangle(new Vector2D(0.0, 0.25), new Vector2D(1.0, this.filename.getDisplayedSize().getY()), "Search for file", null, Color.WHITE);
        this.presets = new ConfigFileList(LabelConfiguration.presets, new Vector2D(0.06666666666666667, 0.05), new Vector2D(0.4, 0.9));
        this.presets.setTitle("Presets");
        this.addChild(this.presets, 15, Anchor.TOP_LEFT);
        this.presets.bottomCover.setHeight(0.13, true);
        this.presets.bottomCover.backgroundColor = null;
        this.presets.bottomCover.addChild(r, 6, Anchor.CENTER, Anchor.TOP_CENTER);
        this.presets.bottomCover.addChild(this.filename, 6, Anchor.CENTER, Anchor.BOTTOM_CENTER);
        this.savedConfigs = new ConfigFileList(LabelConfiguration.savedConfigs, new Vector2D(0.06666666666666667, 0.05), new Vector2D(0.4, 0.9));
        this.savedConfigs.setTitle("Saved Configurations");
        this.addChild(this.savedConfigs, 15, Anchor.TOP_RIGHT);
        Button reloadCurrent = new Button("Reload from file", Vector2D.ZERO, new Vector2D(0.8, 20.0), b -> {
            if (b != Mouse.Button.LEFT) {
                return;
            }
            LabelConfiguration.currentConfig.reloadFromFile();
            ((MainGuiScreen)this.paneHolder).reloadConfig();
        });
        this.savedConfigs.bottomCover.setHeight(0.1, true);
        this.savedConfigs.bottomCover.backgroundColor = null;
        this.savedConfigs.bottomCover.addChild(reloadCurrent, 4, Anchor.CENTER);
    }

    public void reload() {
        this.presets.reloadItems();
        this.presets.updateItems();
        this.savedConfigs.reloadItems();
        this.savedConfigs.updateItems();
    }

    private class ConfigFileListItem
    extends ScrollableListItem<ConfigFileListItem> {
        public String file;

        public ConfigFileListItem(ScrollableList<ConfigFileListItem> parent, String file, LabelConfiguration configuration) {
            super(parent);
            this.setHeight(25.0);
            this.file = file;
            this.addChild(new Button("Load", new Vector2D(5.0, 0.0), new Vector2D(30.0, 20.0), mouseButton -> {
                if (mouseButton != Mouse.Button.LEFT) {
                    return;
                }
                configuration.selectAsCurrent();
                ((MainGuiScreen)LoadConfigPane.this.paneHolder).reloadConfig();
                LoadConfigPane.this.close();
            }), 2, Anchor.CENTER_RIGHT);
        }

        @Override
        public void render(int index, Vector2D pos, Vector2D size, Vector2D mouse) {
            Renderer2D.drawHollowRect(pos.add(1.0), size.sub(2.0), 1.0, edgeColor);
            FontRenderer.drawLeftCenteredString(this.file, pos.add(5.0, size.getY() / 2.0), Color.WHITE, true);
            this.renderComponents(mouse);
        }
    }

    private class ConfigFileList
    extends ScrollableList<ConfigFileListItem> {
        public Map<String, LabelConfiguration> configurationMap;
        public List<ConfigFileListItem> allItems;

        public ConfigFileList(Map<String, LabelConfiguration> configurationMap, Vector2D pos, Vector2D size) {
            this.setPos(pos);
            this.setSize(size);
            this.configurationMap = configurationMap;
            this.reloadItems();
            this.items.clear();
            this.items.addAll(this.allItems);
        }

        public void reloadItems() {
            this.allItems = this.configurationMap.entrySet().stream().map(e -> new ConfigFileListItem(this, (String)e.getKey(), (LabelConfiguration)e.getValue())).sorted(Comparator.comparing(i -> i.file)).collect(Collectors.toList());
        }

        @Override
        public void render(Vector2D mouse) {
            super.render(mouse);
        }

        public void updateItems() {
            this.items.clear();
            for (ConfigFileListItem item : this.allItems) {
                if (!item.file.toLowerCase().contains(((LoadConfigPane)LoadConfigPane.this).filename.content.toLowerCase())) continue;
                this.items.add(item);
            }
        }
    }
}

