/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.screens.main_gui;

import io.github.kurrycat.mpkmod.Main;
import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.Div;
import io.github.kurrycat.mpkmod.gui.components.Label;
import io.github.kurrycat.mpkmod.gui.components.NumberSlider;
import io.github.kurrycat.mpkmod.gui.components.Pane;
import io.github.kurrycat.mpkmod.gui.components.ScrollableList;
import io.github.kurrycat.mpkmod.gui.components.ScrollableListItem;
import io.github.kurrycat.mpkmod.gui.components.TextRectangle;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.MainGuiScreen;
import io.github.kurrycat.mpkmod.gui.screens.options_gui.Option;
import io.github.kurrycat.mpkmod.util.ItrUtil;
import io.github.kurrycat.mpkmod.util.Vector2D;
import io.github.kurrycat.mpkmod.util.WorldToFile;
import java.awt.Color;

public class OptionsPane
extends Pane<MainGuiScreen> {
    public OptionsPane(Vector2D pos, Vector2D size) {
        super(pos, size);
        this.backgroundColor = new Color(16, 16, 16, 70);
        this.addTitle("Options");
        this.initComponents();
    }

    @Override
    public void close() {
        Option.updateOptionMapFromFields();
        Option.saveOptionMapToJSON();
        super.close();
    }

    private void initComponents() {
        OptionList optionList = new OptionList(new Vector2D(0.0, 0.05), new Vector2D(0.9, 0.8));
        this.addChild(optionList, 15, Anchor.CENTER);
        OptionItem pkcOption = new OptionItem(optionList);
        pkcOption.setHeight(20.0);
        TextRectangle radiusText = new TextRectangle(new Vector2D(0.0, 0.0), new Vector2D(45.0, 1.0), "Radius:", new Color(0, 0, 0, 0), Color.WHITE);
        pkcOption.addChild(radiusText, 8);
        Div pkcContent = new Div(new Vector2D(0.0, 0.0), new Vector2D(-2.0, -2.0));
        pkcOption.addChild(pkcContent, 0, Anchor.CENTER);
        pkcOption.stretchXBetween(pkcContent, radiusText, null);
        NumberSlider pkcFileRadius = new NumberSlider(1.0, 20.0, 1.0, 5.0, new Vector2D(0.0, 0.0), new Vector2D(0.45, 1.0), v -> {});
        pkcContent.addChild(pkcFileRadius, 15);
        pkcContent.addChild(new Button("Save as PKC File", new Vector2D(0.5, 0.0), new Vector2D(0.5, 1.0), mouseButton -> WorldToFile.parseWorld((int)pkcFileRadius.getValue())), 15);
        optionList.addItem(pkcOption);
        OptionItem fontSizeOption = new OptionItem(optionList);
        fontSizeOption.setHeight(20.0);
        TextRectangle fontSizeText = new TextRectangle(new Vector2D(0.0, 0.0), new Vector2D(100.0, 1.0), "Default Font Size:", new Color(0, 0, 0, 0), Color.WHITE);
        fontSizeOption.addChild(fontSizeText, 8);
        Div fontSizeContent = new Div(new Vector2D(0.0, 0.0), new Vector2D(-2.0, -2.0));
        fontSizeOption.addChild(fontSizeContent, 0, Anchor.CENTER);
        fontSizeOption.stretchXBetween(fontSizeContent, fontSizeText, null);
        fontSizeContent.addChild(new NumberSlider(2.0, 30.0, 1.0, Label.DEFAULT_FONT_SIZE, new Vector2D(0.0, 0.0), new Vector2D(1.0, 1.0), v -> {
            for (Label l : ItrUtil.getAllOfType(Label.class, Main.mainGUI.movableComponents)) {
                if (l.fontSize != Label.DEFAULT_FONT_SIZE) continue;
                l.fontSize = v;
            }
            Label.DEFAULT_FONT_SIZE = v;
        }), 12, Anchor.TOP_RIGHT);
        optionList.addItem(fontSizeOption);
    }

    @Override
    public void render(Vector2D mousePos) {
        super.render(mousePos);
    }

    private static class OptionItem
    extends ScrollableListItem<OptionItem> {
        public OptionItem(ScrollableList<OptionItem> parent) {
            super(parent);
        }

        @Override
        public void render(int index, Vector2D pos, Vector2D size, Vector2D mouse) {
            this.renderDefaultBorder(pos, size);
            this.renderComponents(mouse);
        }
    }

    private static class OptionList
    extends ScrollableList<OptionItem> {
        public OptionList(Vector2D pos, Vector2D size) {
            this.setPos(pos);
            this.setSize(size);
        }
    }
}

