/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.landingblock;

import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Player;
import io.github.kurrycat.mpkmod.gui.infovars.InfoString;
import io.github.kurrycat.mpkmod.util.BoundingBox3D;
import io.github.kurrycat.mpkmod.util.Vector3D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@InfoString.DataClass
public class LandingBlock {
    public static final int MAX_OFFSETS_SAVED = 500;
    public LandingMode landingMode = LandingMode.LAND;
    @InfoString.Field
    public BoundingBox3D boundingBox;
    public boolean enabled = true;
    public boolean highlight = false;
    public List<Vector3D> offsets = new ArrayList<Vector3D>();
    @InfoString.Field
    public Vector3D pb = null;
    @InfoString.Field
    public Vector3D pbX = null;
    @InfoString.Field
    public Vector3D pbZ = null;
    public long lastTimeOffsetSaved = 0L;

    public static List<LandingBlock> asLandingBlocks(List<BoundingBox3D> collisionBoundingBoxes) {
        return collisionBoundingBoxes.stream().map(LandingBlock::new).collect(Collectors.toCollection(ArrayList::new));
    }

    public LandingBlock(BoundingBox3D boundingBox) {
        this.boundingBox = boundingBox;
    }

    @InfoString.Getter
    public Vector3D getOffset() {
        if (this.offsets.size() == 0) {
            return null;
        }
        return this.offsets.get(this.offsets.size() - 1);
    }

    public Vector3D saveOffsetIfInRange() {
        if (!this.isTryingToLandOn()) {
            return null;
        }
        BoundingBox3D playerBB = this.landingMode.getPlayerBB();
        if (playerBB == null) {
            return null;
        }
        Vector3D offset = this.boundingBox.distanceTo(playerBB).mult(-1.0);
        if (offset.getX() <= (double)-0.3f || offset.getZ() <= (double)-0.3f) {
            return null;
        }
        this.offsets.add(offset);
        while (this.offsets.size() > 500) {
            this.offsets.remove(0);
        }
        if (this.pb == null) {
            this.pb = offset;
        } else if (this.calculateOffsetDist(offset) > this.calculateOffsetDist(this.pb)) {
            this.pb = offset;
        }
        if (this.pbX == null || offset.getX() > this.pbX.getX()) {
            this.pbX = offset;
        }
        if (this.pbZ == null || offset.getZ() > this.pbZ.getZ()) {
            this.pbZ = offset;
        }
        this.lastTimeOffsetSaved = API.tickTime;
        return offset.copy();
    }

    public boolean isTryingToLandOn() {
        if (Player.getLatest() == null) {
            return false;
        }
        BoundingBox3D playerBB = Player.getLatest().getBoundingBox();
        BoundingBox3D lastPlayerBB = Player.getLatest().getLastBoundingBox();
        if (this.landingMode != LandingMode.ENTER) {
            return playerBB.minY() <= this.boundingBox.maxY() && lastPlayerBB.minY() > this.boundingBox.maxY();
        }
        return playerBB.minY() < this.boundingBox.maxY() && playerBB.minY() >= this.boundingBox.minY() && playerBB.minY() < lastPlayerBB.minY();
    }

    private double calculateOffsetDist(Vector3D offset) {
        double xSign = Math.signum(offset.getX());
        double zSign = Math.signum(offset.getZ());
        if (xSign <= 0.0 && zSign >= 0.0) {
            return offset.getX();
        }
        if (xSign >= 0.0 && zSign <= 0.0) {
            return offset.getZ();
        }
        if (xSign <= 0.0 && zSign <= 0.0) {
            return -offset.lengthXZ();
        }
        return offset.lengthXZ();
    }

    public int hashCode() {
        return this.boundingBox.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof LandingBlock && this.boundingBox.equals(((LandingBlock)obj).boundingBox);
    }

    public static enum LandingMode {
        LAND("Land"),
        HIT("Hit"),
        Z_NEO("Z Neo"),
        ENTER("Enter");

        public final String displayString;

        private LandingMode(String displayString) {
            this.displayString = displayString;
        }

        public BoundingBox3D getPlayerBB() {
            if (Player.getLatest() == null) {
                return null;
            }
            switch (this) {
                case Z_NEO: {
                    if (Player.getBeforeLatest() == null) {
                        return null;
                    }
                    return Player.getBeforeLatest().getLastBoundingBox();
                }
                case HIT: 
                case ENTER: {
                    return Player.getLatest().getBoundingBox();
                }
            }
            return Player.getLatest().getLastBoundingBox();
        }

        public LandingMode getNext() {
            return LandingMode.values()[(Arrays.asList(LandingMode.values()).indexOf((Object)this) + 1) % LandingMode.values().length];
        }

        public String toString() {
            return this.displayString;
        }
    }
}

