/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.modules;

import io.github.kurrycat.mpkmod.Main;
import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.events.EventAPI;
import io.github.kurrycat.mpkmod.modules.MPKModuleConfig;
import io.github.kurrycat.mpkmod.modules.MPKModuleImpl;
import io.github.kurrycat.mpkmod.modules.ModuleFinder;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ModuleManager {
    public static final HashMap<String, MPKModuleImpl> moduleMap = new HashMap();

    public static void reloadAllModules() {
        ModuleManager.loadModules(false);
    }

    private static void loadModules(boolean init) {
        Map<MPKModuleConfig, File> modules = ModuleFinder.findAllModules();
        for (Map.Entry<MPKModuleConfig, File> module : modules.entrySet()) {
            try {
                ModuleManager.registerModule(ModuleFinder.getAsImpl(module.getKey(), module.getValue()), init);
            }
            catch (Exception e) {
                API.LOGGER.info("Failed to register module " + module.getKey().moduleName + " in: " + module.getValue().getName());
                API.LOGGER.info("Reason: " + e.getMessage());
            }
        }
    }

    public static void registerModule(MPKModuleImpl module, boolean init) {
        boolean alreadyLoaded = moduleMap.containsKey(module.getName());
        API.LOGGER.info((alreadyLoaded ? "Reloaded" : "Loaded") + " module " + module.getName());
        MPKModuleImpl prev = moduleMap.put(module.getName(), module);
        if (prev != null) {
            prev.closeLoader();
        }
        try {
            if (init) {
                module.getModule().init();
            } else {
                EventAPI.loading(module.getName());
                module.getModule().loaded();
                EventAPI.finishLoading();
            }
        }
        catch (Exception e) {
            API.LOGGER.info("Caught exception during " + (init ? "initialization" : "reloading") + " of module: " + module.getName(), (Throwable)e);
        }
    }

    public static void unloadModule(MPKModuleImpl module) {
        if (module.getModule() instanceof Main) {
            return;
        }
        module.getModule().unloaded();
        EventAPI.unload(module.getName());
        module.closeLoader();
        moduleMap.remove(module.getName());
    }

    public static void initAllModules() {
        ModuleManager.loadModules(true);
    }

    public static void loadAllModules() {
        for (Map.Entry<String, MPKModuleImpl> entry : moduleMap.entrySet()) {
            try {
                EventAPI.loading(entry.getValue().getName());
                entry.getValue().getModule().loaded();
            }
            catch (Exception e) {
                API.LOGGER.info("Caught exception during loading of module: " + entry.getValue().getName(), (Throwable)e);
            }
        }
        EventAPI.finishLoading();
    }

    public static void closeAllModules() {
        for (Map.Entry<String, MPKModuleImpl> entry : moduleMap.entrySet()) {
            try {
                entry.getValue().closeLoader();
            }
            catch (Exception e) {
                API.LOGGER.info("Caught exception during closing of module: " + entry.getValue().getName(), (Throwable)e);
            }
        }
    }
}

