/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.util.Vector2D;

public class JSONPos2D {
    private final Anchor anchor;
    private final Anchor parentAnchor;
    private final double x;
    private final double y;
    private final int percentFlag;

    public JSONPos2D(Vector2D pos, Anchor anchor, Anchor parentAnchor, int percentFlag) {
        this.x = pos.getX();
        this.y = pos.getY();
        this.anchor = anchor;
        this.parentAnchor = parentAnchor;
        this.percentFlag = percentFlag;
    }

    @JsonCreator
    public JSONPos2D(@JsonProperty(value="x") double x, @JsonProperty(value="y") double y, @JsonProperty(value="anchor") Anchor anchor, @JsonProperty(value="parentAnchor") Anchor parentAnchor, @JsonProperty(value="percentFlag") int percentFlag) {
        if (anchor == null && parentAnchor == null) {
            this.x = Math.abs(x);
            this.y = Math.abs(y);
            this.parentAnchor = this.anchor = Anchor.fromPos(new Vector2D(x, y));
            this.percentFlag = 0;
        } else {
            this.x = x;
            this.y = y;
            this.anchor = anchor;
            this.parentAnchor = parentAnchor;
            this.percentFlag = percentFlag;
        }
    }

    public Vector2D getPos() {
        return new Vector2D(this.x, this.y);
    }

    @JsonGetter(value="x")
    public double getX() {
        return this.x;
    }

    @JsonGetter(value="y")
    public double getY() {
        return this.y;
    }

    @JsonGetter(value="anchor")
    public Anchor getAnchor() {
        return this.anchor;
    }

    @JsonGetter(value="parentAnchor")
    public Anchor getParentAnchor() {
        return this.parentAnchor;
    }

    @JsonGetter(value="percentFlag")
    public int getPercentFlag() {
        return this.percentFlag;
    }
}

