/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.compatibility.MCClasses;

import io.github.kurrycat.mpkmod.Main;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.KeyBinding;
import io.github.kurrycat.mpkmod.gui.infovars.InfoString;
import io.github.kurrycat.mpkmod.gui.screens.LandingBlockGuiScreen;
import io.github.kurrycat.mpkmod.landingblock.LandingBlock;
import io.github.kurrycat.mpkmod.ticks.ButtonMSList;
import io.github.kurrycat.mpkmod.ticks.TimingInput;
import io.github.kurrycat.mpkmod.ticks.TimingStorage;
import io.github.kurrycat.mpkmod.util.BoundingBox3D;
import io.github.kurrycat.mpkmod.util.Copyable;
import io.github.kurrycat.mpkmod.util.FormatDecimals;
import io.github.kurrycat.mpkmod.util.MathUtil;
import io.github.kurrycat.mpkmod.util.Tuple;
import io.github.kurrycat.mpkmod.util.Vector2D;
import io.github.kurrycat.mpkmod.util.Vector3D;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class Player {
    public static ArrayList<Player> tickHistory = new ArrayList();
    public static int maxSavedTicks = 100;
    @InfoString.AccessInstance
    public static Player displayInstance = new Player();
    @InfoString.Field
    public PosAndAngle lastLanding = null;
    @InfoString.Field
    public PosAndAngle lastHit = null;
    @InfoString.Field
    public PosAndAngle lastJump = null;
    @InfoString.Field
    public Blip lastBlip = null;
    public TimingInput timingInput = new TimingInput("");
    public KeyInput keyInput = null;
    public ButtonMSList keyMSList = null;
    public Vector3D pos = null;
    public Vector3D lastPos = null;
    public Float trueYaw = null;
    public Float truePitch = null;
    public Vector3D motion = null;
    public boolean onGround = false;
    public Float deltaYaw = null;
    public Float deltaPitch = null;
    public int[] deltaMouseX = null;
    public int[] deltaMouseY = null;
    public int airtime = 0;
    public Float last45 = null;
    public boolean jumpTick = false;
    public boolean landTick = false;
    public String lastTiming = "None";
    public boolean sprinting = false;
    public BoundingBox3D boundingBox = null;

    @InfoString.Getter
    public static LandingBlock getLatestLB() {
        return LandingBlockGuiScreen.lbs.stream().filter(lb -> lb.pb != null).min(Comparator.comparing(o -> o.lastTimeOffsetSaved)).orElse(new LandingBlock(BoundingBox3D.ZERO));
    }

    @InfoString.Getter
    public static List<String> compressedInputHistory() {
        return Player.getInputHistory().stream().reduce(new ArrayList(), (l, t) -> {
            if (l.size() == 0) {
                l.add(new Tuple<Integer, TimingInput>(1, (TimingInput)t));
                return l;
            }
            Tuple last = (Tuple)l.get(l.size() - 1);
            if (((TimingInput)last.getSecond()).equals(t)) {
                last.setFirst((Integer)last.getFirst() + 1);
            } else {
                l.add(new Tuple<Integer, TimingInput>(1, (TimingInput)t));
            }
            return l;
        }, (l1, l2) -> {
            ArrayList list = new ArrayList(l1);
            list.addAll(l2);
            return list;
        }).stream().map(Object::toString).collect(Collectors.toList());
    }

    public static List<TimingInput> getInputHistory() {
        return tickHistory.stream().map(p -> p.timingInput).collect(Collectors.toList());
    }

    @InfoString.Getter
    public Float getLast45() {
        return this.last45;
    }

    public Player constructKeyInput() {
        this.keyInput = KeyInput.construct();
        return this;
    }

    public Player setKeyInput(KeyInput keyInput) {
        this.keyInput = keyInput;
        return this;
    }

    public Player setKeyMSList(ButtonMSList keyMS) {
        this.keyMSList = keyMS;
        return this;
    }

    @InfoString.Getter
    public boolean isOnGround() {
        return this.onGround;
    }

    public Player setOnGround(boolean onGround) {
        this.onGround = onGround;
        return this;
    }

    @InfoString.Getter
    public String getFacing() {
        double yaw = this.getYaw().floatValue();
        int xz = (int)Math.floor(Math.abs(yaw / 45.0));
        return Arrays.asList(0, 3, 4).contains(xz) ? "Z" : "X";
    }

    @InfoString.Getter
    public Float getYaw() {
        if (this.trueYaw == null) {
            return null;
        }
        return Float.valueOf(MathUtil.wrapDegrees(this.trueYaw.floatValue()));
    }

    @InfoString.Getter
    public Float getTrueYaw() {
        return this.trueYaw;
    }

    @InfoString.Getter
    public Float getTruePitch() {
        return this.truePitch;
    }

    @InfoString.Getter
    public Float getPitch() {
        if (this.truePitch == null) {
            return null;
        }
        return Float.valueOf(MathUtil.wrapDegrees(this.truePitch.floatValue()));
    }

    public Player setRotation(Float yaw, Float pitch) {
        this.trueYaw = yaw;
        this.truePitch = pitch;
        return this;
    }

    @InfoString.Getter
    public String getLastInputs() {
        return this.keyInput == null ? "" : (this.keyInput.forward ? "W" : "") + (this.keyInput.left ? "A" : "") + (this.keyInput.back ? "S" : "") + (this.keyInput.right ? "D" : "") + (this.keyInput.sprint ? "P" : "") + (this.keyInput.sneak ? "N" : "") + (this.keyInput.jump ? "J" : "");
    }

    @InfoString.Getter
    public Float getDeltaYaw() {
        return Float.valueOf(this.deltaYaw == null ? 0.0f : this.deltaYaw.floatValue());
    }

    @InfoString.Getter
    public Float getDeltaPitch() {
        return Float.valueOf(this.deltaPitch == null ? 0.0f : this.deltaPitch.floatValue());
    }

    @InfoString.Getter
    public Vector3D getMotion() {
        return this.motion;
    }

    public Player setMotion(Vector3D motion) {
        this.motion = motion;
        return this;
    }

    @InfoString.Getter
    public Vector3D getSpeed() {
        return this.pos.sub(this.lastPos);
    }

    @InfoString.Getter
    public int getAirtime() {
        return this.airtime;
    }

    @InfoString.Getter
    public int getTier() {
        return -(this.airtime - 12);
    }

    @InfoString.Getter
    public boolean isSprinting() {
        return this.sprinting;
    }

    public Player setSprinting(boolean sprinting) {
        this.sprinting = sprinting;
        return this;
    }

    @InfoString.Getter
    public String getLastTiming() {
        return this.lastTiming;
    }

    public Player buildAndSave() {
        Player prev = Player.getLatest();
        Player pprev = Player.getBeforeLatest();
        Player.savePlayerState(this);
        if (prev == null) {
            Player.updateDisplayInstance();
            return this;
        }
        this.airtime = prev.onGround ? 0 : prev.airtime + 1;
        if (prev.onGround && !this.onGround) {
            this.airtime = 1;
        }
        this.landTick = !prev.onGround && this.onGround;
        this.jumpTick = !this.onGround && prev.onGround && this.keyInput.jump;
        this.lastLanding = this.landTick ? new PosAndAngle(prev.pos, prev.trueYaw.floatValue(), prev.truePitch.floatValue()) : prev.lastLanding;
        this.lastHit = prev.landTick ? new PosAndAngle(prev.pos, prev.trueYaw.floatValue(), prev.truePitch.floatValue()) : prev.lastHit;
        this.lastJump = this.jumpTick ? new PosAndAngle(prev.pos, prev.trueYaw.floatValue(), prev.truePitch.floatValue()) : prev.lastJump;
        this.deltaYaw = Float.valueOf(this.trueYaw.floatValue() - prev.trueYaw.floatValue());
        if (this.deltaYaw.floatValue() == 0.0f) {
            this.deltaYaw = null;
        }
        this.deltaPitch = Float.valueOf(this.truePitch.floatValue() - prev.truePitch.floatValue());
        if (this.deltaPitch.floatValue() == 0.0f) {
            this.deltaPitch = null;
        }
        this.deltaMouseX = new int[Main.mouseMovements.size()];
        this.deltaMouseY = new int[Main.mouseMovements.size()];
        for (int i = 0; i < Main.mouseMovements.size(); ++i) {
            this.deltaMouseX[i] = Main.mouseMovements.get(i).getXI();
            this.deltaMouseY[i] = Main.mouseMovements.get(i).getYI();
        }
        Main.mouseMovements.clear();
        this.timingInput = new TimingInput(this.keyInput.forward, this.keyInput.left, this.keyInput.back, this.keyInput.right, this.sprinting, this.keyInput.sneak, this.jumpTick, this.onGround);
        if (this.keyMSList != null) {
            this.timingInput.msList.addAll(this.keyMSList);
        }
        if (prev.jumpTick && !prev.keyInput.isMovingSideways() && this.keyInput.isMovingSideways()) {
            this.last45 = prev.deltaYaw;
        }
        this.lastTiming = TimingStorage.match(Player.getInputHistory());
        if (pprev == null) {
            Player.updateDisplayInstance();
            return this;
        }
        this.lastBlip = prev.lastBlip;
        if (this.onGround && !prev.onGround && this.pos.getY() == prev.pos.getY() && !prev.jumpTick) {
            this.lastBlip = this.lastBlip == null ? new Blip(1, this.pos) : new Blip(this.lastBlip.chainedBlips + 1, this.pos);
        } else if (this.onGround && this.lastBlip != null) {
            this.lastBlip = new Blip(0, this.lastBlip.lastChainedBlips, this.lastBlip.pos);
        }
        Player.updateDisplayInstance();
        return this;
    }

    public static Player getLatest() {
        if (tickHistory.isEmpty()) {
            return null;
        }
        return tickHistory.get(tickHistory.size() - 1);
    }

    public static Player getBeforeLatest() {
        if (tickHistory.size() < 2) {
            return null;
        }
        return tickHistory.get(tickHistory.size() - 2);
    }

    public static void savePlayerState(Player player) {
        tickHistory.add(player);
        if (tickHistory.size() > maxSavedTicks) {
            tickHistory.remove(0);
        }
    }

    public static void updateDisplayInstance() {
        try {
            for (Field f : Player.class.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                f.setAccessible(true);
                Object o = f.get(Player.getLatest());
                if (o == null || o instanceof Integer && (Integer)o == 0) continue;
                if (o instanceof Vector3D) {
                    f.set(displayInstance, ((Vector3D)o).copy());
                    continue;
                }
                if (o instanceof Copyable) {
                    f.set(displayInstance, ((Copyable)o).copy());
                    continue;
                }
                f.set(displayInstance, o);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public Player getPrevious() {
        int i = tickHistory.indexOf(this);
        if (i <= 0) {
            return null;
        }
        return tickHistory.get(i - 1);
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    @InfoString.Getter
    public Vector3D getBoundingBoxSize() {
        return this.boundingBox.getSize();
    }

    public Player setBoundingBox(BoundingBox3D boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    @InfoString.Getter
    public Vector3D getPos() {
        return this.pos;
    }

    public Player setPos(Vector3D pos) {
        this.pos = pos;
        return this;
    }

    public BoundingBox3D getLastBoundingBox() {
        return this.getPrevious().getBoundingBox();
    }

    public Vector3D getLastBoundingBoxSize() {
        return this.getLastBoundingBox().getSize();
    }

    @InfoString.Getter
    public Vector3D getLastPos() {
        return this.lastPos;
    }

    public Player setLastPos(Vector3D lastPos) {
        this.lastPos = lastPos;
        return this;
    }

    public static class KeyInput {
        public boolean forward = false;
        public boolean left = false;
        public boolean back = false;
        public boolean right = false;
        public boolean sprint = false;
        public boolean sneak = false;
        public boolean jump = false;

        public KeyInput() {
        }

        public KeyInput(boolean forward, boolean left, boolean back, boolean right, boolean sprint, boolean sneak, boolean jump) {
            this.forward = forward;
            this.left = left;
            this.back = back;
            this.right = right;
            this.sprint = sprint;
            this.sneak = sneak;
            this.jump = jump;
        }

        public static KeyInput construct() {
            KeyInput k = new KeyInput();
            for (Field f : KeyInput.class.getDeclaredFields()) {
                KeyBinding b = KeyBinding.getByName("key." + f.getName());
                if (b == null) continue;
                try {
                    f.set(k, b.isKeyDown());
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return k;
        }

        public String toString() {
            return "{W:" + this.forward + ", A:" + this.left + ", S:" + this.back + ", D:" + this.right + ", N:" + this.sneak + ", P:" + this.sprint + ", J:" + this.jump + "}";
        }

        public Vector2D getMovementVector() {
            Vector2D vector2D = Vector2D.ZERO;
            if (this.forward) {
                vector2D = vector2D.add(1.0, 0.0);
            }
            if (this.back) {
                vector2D = vector2D.add(-1.0, 0.0);
            }
            if (this.left) {
                vector2D = vector2D.add(0.0, -1.0);
            }
            if (this.right) {
                vector2D = vector2D.add(0.0, 1.0);
            }
            return vector2D;
        }

        public boolean isMovingSideways() {
            return this.left ^ this.right;
        }
    }

    @InfoString.DataClass
    public static class PosAndAngle
    implements FormatDecimals {
        @InfoString.Field
        public final Vector3D pos;
        @InfoString.Field
        public final float trueYaw;
        @InfoString.Field
        public final float truePitch;
        @InfoString.Field
        public final float yaw;
        @InfoString.Field
        public final float pitch;

        public PosAndAngle(Vector3D pos, float trueYaw, float truePitch) {
            this.pos = pos;
            this.trueYaw = trueYaw;
            this.truePitch = truePitch;
            this.yaw = MathUtil.wrapDegrees(trueYaw);
            this.pitch = MathUtil.wrapDegrees(truePitch);
        }

        public String toString() {
            return "[" + this.yaw + ", " + this.pitch + ", " + this.pos.toString() + "]";
        }

        @Override
        public String formatDecimals(int decimals, boolean keepZeros) {
            return "[" + MathUtil.formatDecimals(this.yaw, decimals, keepZeros) + ", " + MathUtil.formatDecimals(this.pitch, decimals, keepZeros) + ", " + this.pos.formatDecimals(decimals, keepZeros) + "]";
        }
    }

    @InfoString.DataClass
    public static class Blip
    implements FormatDecimals {
        @InfoString.Field
        public final int chainedBlips;
        @InfoString.Field
        public final int lastChainedBlips;
        @InfoString.Field
        public final Vector3D pos;

        public Blip(int chainedBlips, Vector3D pos) {
            this.chainedBlips = chainedBlips;
            this.lastChainedBlips = chainedBlips;
            this.pos = pos;
        }

        public Blip(int chainedBlips, int lastChainedBlips, Vector3D pos) {
            this.chainedBlips = chainedBlips;
            this.lastChainedBlips = lastChainedBlips;
            this.pos = pos;
        }

        @Override
        public String formatDecimals(int decimals, boolean keepZeros) {
            return "[" + this.chainedBlips + ", " + this.lastChainedBlips + ", " + this.pos.formatDecimals(decimals, keepZeros) + "]";
        }
    }
}

