/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Player;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.NumberSlider;
import io.github.kurrycat.mpkmod.gui.components.PopupMenu;
import io.github.kurrycat.mpkmod.gui.components.ResizableComponent;
import io.github.kurrycat.mpkmod.gui.components.TextCheckButton;
import io.github.kurrycat.mpkmod.gui.screens.main_gui.MainGuiScreen;
import io.github.kurrycat.mpkmod.util.ColorUtil;
import io.github.kurrycat.mpkmod.util.MathUtil;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;

public class InputHistory
extends ResizableComponent {
    static ArrayList<InputHistoryMessage> inputHistory = new ArrayList();
    @JsonProperty
    public Color backgroundColor = new Color(100, 100, 100, 40);
    @JsonProperty
    public Color messageColor = new Color(255, 255, 255, 255);
    @JsonProperty
    public Color edgeColor = new Color(100, 100, 100, 50);
    public Color selectedColor = new Color(255, 170, 0, 100);
    @JsonProperty
    public boolean inverted = false;
    @JsonProperty
    int maxTickAge = 80;
    @JsonProperty
    public boolean transparentBackground = false;
    public static int preferredWidth = 86;
    public int maxStoredMessages = 30;
    private static final HashMap<Vector2D, String> movementCharacters = new HashMap();

    @JsonCreator
    public InputHistory() {
        this.setMinSize(new Vector2D(preferredWidth, 60.0));
        this.setXResizeLocked(true);
    }

    @Override
    public void render(Vector2D mouse) {
        if (!this.transparentBackground) {
            Renderer2D.drawRectWithEdge(this.getDisplayedPos(), this.getDisplayedSize(), 1.0, this.selected ? this.selectedColor : this.backgroundColor, this.edgeColor);
        }
        if (this.highlighted) {
            Renderer2D.drawDottedRect(this.getDisplayedPos(), this.getDisplayedSize(), 1.0, 1.0, 1.0, Color.BLACK);
        }
        double lineHeight = 10.0;
        int maxDisplayedMessages = (int)((this.getDisplayedSize().getY() - 2.0) / lineHeight - 0.5);
        for (int i = 0; i < inputHistory.size() && i < maxDisplayedMessages; ++i) {
            double yOffset = this.inverted ? (double)this.getDisplayedSize().getYI() - (double)(1 + i) * lineHeight : (double)(1 + i) * lineHeight;
            inputHistory.get(i).render(new Vector2D(this.getDisplayedPos().getXI(), (double)this.getDisplayedPos().getYI() + yOffset));
        }
        this.renderHoverEdges(mouse);
    }

    public void onTick() {
        Player.KeyInput keyInput;
        Player.KeyInput keyInput2 = keyInput = Player.getLatest() == null ? null : Player.getLatest().keyInput;
        if (keyInput == null) {
            return;
        }
        StringBuilder keysPressed = new StringBuilder();
        keysPressed.append(movementCharacters.getOrDefault(keyInput.getMovementVector(), " "));
        keysPressed.append(' ');
        keysPressed.append(keyInput.jump ? (char)'J' : ' ');
        keysPressed.append(' ');
        keysPressed.append(keyInput.sneak ? "Sn" : "  ");
        keysPressed.append(' ');
        keysPressed.append(keyInput.sprint ? "Sp" : "  ");
        if (!inputHistory.isEmpty() && keysPressed.toString().equals(InputHistory.inputHistory.get((int)0).keysPressed)) {
            inputHistory.get(0).stillPressed();
        } else {
            inputHistory.add(0, new InputHistoryMessage(keysPressed.toString()));
        }
        if (inputHistory.size() > this.maxStoredMessages) {
            inputHistory.subList(this.maxStoredMessages, inputHistory.size()).clear();
        }
        for (InputHistoryMessage message : inputHistory) {
            message.tick();
        }
    }

    @Override
    public PopupMenu getPopupMenu() {
        PopupMenu menu = new PopupMenu();
        menu.addComponent(new TextCheckButton(Vector2D.OFFSCREEN, "Inverted", this.inverted, checked -> {
            this.inverted = checked;
        }));
        menu.addComponent(new TextCheckButton(Vector2D.OFFSCREEN, "Background", !this.transparentBackground, checked -> {
            this.transparentBackground = !checked;
        }));
        menu.addComponent(new NumberSlider(20.0, 300.0, 1.0, this.maxTickAge - 20, Vector2D.OFFSCREEN, new Vector2D(56.0, 11.0), sliderValue -> {
            this.maxTickAge = (int)sliderValue + 20;
        }));
        menu.addComponent(new Button("Delete", mouseButton -> {
            if (Mouse.Button.LEFT.equals((Object)mouseButton)) {
                ((MainGuiScreen)menu.paneHolder).removeComponent(this);
                menu.close();
            }
        }));
        return menu;
    }

    static {
        movementCharacters.put(new Vector2D(0.0, 0.0), " ");
        movementCharacters.put(new Vector2D(-1.0, 0.0), "\u2b07");
        movementCharacters.put(new Vector2D(1.0, 0.0), "\u2b06");
        movementCharacters.put(new Vector2D(0.0, -1.0), "\u2b05");
        movementCharacters.put(new Vector2D(0.0, 1.0), "\u27a1");
        movementCharacters.put(new Vector2D(1.0, 1.0), "\u2b08");
        movementCharacters.put(new Vector2D(1.0, -1.0), "\u2b09");
        movementCharacters.put(new Vector2D(-1.0, 1.0), "\u2b0a");
        movementCharacters.put(new Vector2D(-1.0, -1.0), "\u2b0b");
    }

    public class InputHistoryMessage {
        int tickAge = 0;
        int ticksPressed = 1;
        final String keysPressed;
        private int fadeOutAlpha = 255;

        public InputHistoryMessage(String keysPressed) {
            this.keysPressed = keysPressed;
        }

        public void render(Vector2D pos) {
            Color finalMessageColor = ColorUtil.withAlpha(InputHistory.this.messageColor, this.fadeOutAlpha);
            FontRenderer.drawLeftCenteredMonospaceString(this.keysPressed, pos.add(3.0, 0.0), finalMessageColor, true);
            FontRenderer.drawRightCenteredString(String.valueOf(this.ticksPressed), pos.add(preferredWidth - 3, 0.0), finalMessageColor, true);
        }

        public void stillPressed() {
            this.tickAge = 0;
            ++this.ticksPressed;
        }

        public void tick() {
            ++this.tickAge;
            int fadeOutTime = 20;
            this.fadeOutAlpha = this.tickAge < InputHistory.this.maxTickAge - fadeOutTime ? 255 : MathUtil.map(InputHistory.this.maxTickAge - Math.min(this.tickAge, InputHistory.this.maxTickAge), fadeOutTime, 0, 255, 0);
        }
    }
}

