/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.SoundManager;
import io.github.kurrycat.mpkmod.gui.Theme;
import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.Component;
import io.github.kurrycat.mpkmod.gui.components.TextRectangle;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseInputListener;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseScrollListener;
import io.github.kurrycat.mpkmod.util.MathUtil;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;

public class NumberSlider
extends Component
implements MouseInputListener,
MouseScrollListener {
    private final SliderCallback sliderCallback;
    private final double from;
    private final double to;
    private final double step;
    private final Button button;
    private final TextRectangle valueTextRect;
    public Color backgroundColor = new Color(31, 31, 31, 150);
    public Color buttonColor = new Color(150, 150, 150, 150);
    public Color buttonHoverColor = new Color(190, 190, 190, 150);
    public Color buttonPressedColor = new Color(255, 255, 255, 95);
    private double value;
    private boolean isSliding = false;

    public NumberSlider(double from, double to, double step, double value, Vector2D pos, Vector2D size, SliderCallback sliderCallback) {
        this.setPos(pos);
        this.setSize(size);
        this.from = from;
        this.to = to;
        this.step = step;
        this.value = value;
        this.sliderCallback = sliderCallback;
        this.button = new Button("", new Vector2D(this.getRelativeXPosFromValue(), 1.0), new Vector2D(this.getSliderWidth(), -2.0));
        this.passPositionTo(this.button, 0, Anchor.TOP_LEFT);
        this.button.hoverColor = this.buttonHoverColor;
        this.button.normalColor = this.buttonColor;
        this.button.pressedColor = this.buttonPressedColor;
        this.valueTextRect = new TextRectangle(new Vector2D(0.0, 0.0), new Vector2D(1.0, 1.0), MathUtil.formatDecimals(value, 5, false), null, Theme.defaultText);
        this.passPositionTo(this.valueTextRect, 12, Anchor.CENTER);
    }

    private double getRelativeXPosFromValue() {
        return MathUtil.map(this.value, this.from, this.to, 1.0, this.getDisplayedSize().getX() - 1.0 - this.getSliderWidth());
    }

    private double getSliderWidth() {
        return Math.max(5.0, this.step / (this.to - this.from) * this.getDisplayedSize().getX() - 2.0);
    }

    public double getValue() {
        return this.value;
    }

    public NumberSlider setValue(double value) {
        if (this.value == value) {
            return this;
        }
        this.value = value;
        this.button.pos.setX(this.getRelativeXPosFromValue());
        this.button.updatePosAndSize();
        return this;
    }

    @Override
    public void updatePosAndSize() {
        super.updatePosAndSize();
        if (this.button != null) {
            this.button.pos.setX(this.getRelativeXPosFromValue());
            this.button.updatePosAndSize();
        }
    }

    @Override
    public void render(Vector2D mouse) {
        Renderer2D.drawRect(this.getDisplayedPos(), this.getDisplayedSize(), this.backgroundColor);
        this.valueTextRect.setText(MathUtil.formatDecimals(this.value, 5, false));
        this.valueTextRect.render(mouse);
        this.setValue(this.value);
        this.button.render(mouse);
    }

    @Override
    public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
        if (this.contains(mousePos)) {
            this.button.handleMouseInput(state, mousePos, button);
            if (state == Mouse.State.DOWN) {
                this.isSliding = true;
                if (!this.button.isPressed()) {
                    SoundManager.playButtonSound();
                }
                this.button.setPressed(true);
                double beforeValue = this.value;
                this.setValue(this.getValueFromPos(mousePos));
                if (beforeValue != this.value) {
                    this.sliderCallback.apply(this.value);
                }
                return true;
            }
        }
        switch (state) {
            case UP: {
                if (this.isSliding) {
                    this.sliderCallback.apply(this.value);
                }
                this.isSliding = false;
                return this.contains(mousePos);
            }
            case DRAG: {
                if (this.isSliding) {
                    double beforeValue = this.value;
                    this.setValue(this.getValueFromPos(mousePos));
                    if (beforeValue != this.value) {
                        this.sliderCallback.apply(this.value);
                    }
                    return true;
                }
                return false;
            }
        }
        return this.contains(mousePos);
    }

    private double getValueFromPos(Vector2D pos) {
        double v = MathUtil.strictMap(pos.getX() - this.getDisplayedPos().getX(), 1.0 + this.getSliderWidth() / 2.0, this.getDisplayedSize().getX() - 1.0 - this.getSliderWidth() / 2.0, this.from, this.to);
        if (this.step != 0.0) {
            v = MathUtil.constrain(MathUtil.roundToStep(v, this.step), this.from, this.to);
        }
        return v;
    }

    @Override
    public boolean handleMouseScroll(Vector2D mousePos, int delta) {
        if (this.contains(mousePos)) {
            this.setValue(this.value - (delta < 0 ? -1.0 : 1.0 * this.step));
            this.sliderCallback.apply(this.value);
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface SliderCallback {
        public void apply(double var1);
    }
}

