/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.Theme;
import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.Component;
import io.github.kurrycat.mpkmod.gui.components.Div;
import io.github.kurrycat.mpkmod.gui.components.ScrollableListItem;
import io.github.kurrycat.mpkmod.gui.components.TextRectangle;
import io.github.kurrycat.mpkmod.gui.interfaces.HoverComponent;
import io.github.kurrycat.mpkmod.gui.interfaces.KeyInputListener;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseInputListener;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseScrollListener;
import io.github.kurrycat.mpkmod.util.BoundingBox2D;
import io.github.kurrycat.mpkmod.util.Colors;
import io.github.kurrycat.mpkmod.util.ItrUtil;
import io.github.kurrycat.mpkmod.util.MathUtil;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Pair;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ScrollableList<I extends ScrollableListItem<I>>
extends Component
implements MouseInputListener,
MouseScrollListener,
KeyInputListener,
HoverComponent {
    public final List<I> items = new CopyOnWriteArrayList<I>();
    private final TextRectangle titleComponent;
    public Color backgroundColor = Theme.darkBackground;
    public Color edgeColor = Theme.darkEdge;
    public ScrollBar<I> scrollBar;
    public Div topCover = new Div(new Vector2D(0.0, 0.0), new Vector2D(1.0, 0.0));
    public Div bottomCover;
    public Div content;

    public ScrollableList() {
        this.topCover.backgroundColor = this.backgroundColor;
        this.passPositionTo(this.topCover, 4, Anchor.TOP_LEFT);
        this.titleComponent = new TextRectangle(new Vector2D(0.0, 0.0), new Vector2D(1.0, 1.0), "", null, Color.WHITE);
        this.topCover.addChild(this.titleComponent, 12);
        this.bottomCover = new Div(new Vector2D(0.0, 0.0), new Vector2D(1.0, 0.0));
        this.bottomCover.backgroundColor = this.backgroundColor;
        this.passPositionTo(this.bottomCover, 4, Anchor.BOTTOM_LEFT);
        this.content = new Div(new Vector2D(0.0, 0.0), new Vector2D(1.0, 1.0));
        this.passPositionTo(this.content, 12);
        this.stretchYBetween(this.content, this.topCover, this.bottomCover);
        this.scrollBar = new ScrollBar(this);
        this.content.passPositionTo(this.scrollBar, 8, Anchor.TOP_RIGHT);
        this.scrollBar.setSize(new Vector2D(this.scrollBar.barWidth, 1.0));
    }

    public void addItem(I item) {
        this.items.add(item);
    }

    public void setTitle(String title) {
        this.titleComponent.setText((Object)((Object)Colors.UNDERLINE) + title);
        if (this.topCover.getDisplayedSize().getY() < 20.0) {
            this.topCover.setSize(new Vector2D(this.topCover.size.getX(), 20.0));
        }
    }

    public void renderComponents(Vector2D mouse) {
        this.components.forEach(c -> c.render(mouse));
        this.topCover.components.forEach(c -> c.render(mouse));
        this.bottomCover.components.forEach(c -> c.render(mouse));
    }

    @Override
    public void render(Vector2D mouse) {
        this.scrollBar.constrainScrollAmountToScreen();
        int relItemYPos = 1;
        double itemWidth = this.getDisplayedSize().getX() - 2.0;
        if (this.shouldRenderScrollbar()) {
            itemWidth -= this.scrollBar.barWidth - 1.0;
        }
        Renderer2D.enableScissor(this.content.getDisplayedPos().getX(), this.content.getDisplayedPos().getY(), this.content.getDisplayedSize().getX(), this.content.getDisplayedSize().getY() - (double)(!(this.bottomCover.getDisplayedSize().getY() > 0.0) ? 1 : 0));
        int i = 0;
        for (ScrollableListItem item : this.getItems()) {
            double absItemYPos = relItemYPos - ((ScrollBar)this.scrollBar).scrollAmount;
            item.setParent(this.content);
            item.setPos(new Vector2D(1.0, absItemYPos));
            item.setSize(new Vector2D(itemWidth, item.getHeight()));
            if (absItemYPos >= (double)(-item.getHeight()) && absItemYPos <= this.content.getDisplayedSize().getY()) {
                item.render(i, item.getDisplayedPos(), item.getDisplayedSize(), mouse);
            }
            relItemYPos += item.getHeight() + 1;
            ++i;
        }
        Renderer2D.disableScissor();
        Renderer2D.drawHollowRect(this.getDisplayedPos().add(1.0), this.getDisplayedSize().sub(2.0), 1.0, this.edgeColor);
        if (this.topCover.getDisplayedSize().getY() > 0.0) {
            Renderer2D.drawRect(this.topCover.getDisplayedPos().add(0.0, this.topCover.getDisplayedSize().getY()), new Vector2D(this.topCover.getDisplayedSize().getX(), 1.0), this.edgeColor);
        }
        if (this.bottomCover.getDisplayedSize().getY() > 0.0) {
            Renderer2D.drawRect(this.bottomCover.getDisplayedPos(), new Vector2D(this.bottomCover.getDisplayedSize().getX(), 1.0), this.edgeColor);
        }
        if (this.shouldRenderScrollbar()) {
            this.scrollBar.render(mouse);
        }
        this.topCover.render(mouse);
        this.bottomCover.render(mouse);
    }

    private boolean shouldRenderScrollbar() {
        return (double)this.totalHeight() > this.content.getDisplayedSize().getY() - 2.0;
    }

    public Iterable<I> getItems() {
        return this.items;
    }

    public int totalHeight() {
        int sum = 0;
        for (ScrollableListItem item : this.getItems()) {
            sum += item.getHeight() + 1;
        }
        if (sum != 0) {
            sum += 3;
        }
        return sum;
    }

    public Pair<I, Vector2D> getItemAndRelMousePosUnderMouse(Vector2D mouse) {
        double itemWidth = this.content.getDisplayedSize().getX() - 2.0;
        if (this.shouldRenderScrollbar()) {
            itemWidth -= this.scrollBar.barWidth - 1.0;
        }
        if (mouse.getX() < this.content.getDisplayedPos().getX() + 1.0 || mouse.getX() > this.content.getDisplayedPos().getX() + itemWidth + 1.0) {
            return null;
        }
        double currY = mouse.getY() - 1.0 - this.content.getDisplayedPos().getY() + (double)((ScrollBar)this.scrollBar).scrollAmount;
        for (ScrollableListItem item : this.getItems()) {
            if (currY >= 0.0 && currY <= (double)item.getHeight()) {
                return new Pair<ScrollableListItem, Vector2D>(item, new Vector2D(mouse.getX() - this.content.getDisplayedPos().getX() - 1.0, currY));
            }
            currY -= (double)(item.getHeight() + 1);
        }
        return null;
    }

    @Override
    public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
        if (this.shouldRenderScrollbar() && this.scrollBar.handleMouseInput(state, mousePos, button)) {
            return true;
        }
        boolean itemClicked = false;
        if (mousePos.getY() > this.content.getDisplayedPos().getY() && mousePos.getY() < this.content.getDisplayedPos().getY() + this.content.getDisplayedSize().getY()) {
            for (ScrollableListItem item : this.getItems()) {
                if (!item.isVisible()) continue;
                itemClicked = itemClicked || item.handleMouseInput(state, mousePos, button);
            }
        }
        return itemClicked || ItrUtil.orMapAll(ItrUtil.getAllOfType(MouseInputListener.class, this.components, this.topCover.components, this.bottomCover.components), e -> e.handleMouseInput(state, mousePos, button)) || this.contains(mousePos);
    }

    @Override
    public boolean handleMouseScroll(Vector2D mousePos, int delta) {
        if (!this.contains(mousePos)) {
            return false;
        }
        boolean itemClicked = false;
        if (mousePos.getY() > this.content.getDisplayedPos().getY() && mousePos.getY() < this.content.getDisplayedPos().getY() + this.content.getDisplayedSize().getY()) {
            for (ScrollableListItem item : this.getItems()) {
                if (!item.isVisible()) continue;
                itemClicked = itemClicked || item.handleMouseScroll(mousePos, delta);
            }
        }
        if (itemClicked || ItrUtil.orMapAll(ItrUtil.getAllOfType(MouseScrollListener.class, this.components, this.topCover.components, this.bottomCover.components), e -> e.handleMouseScroll(mousePos, delta))) {
            return true;
        }
        if (this.shouldRenderScrollbar()) {
            this.scrollBar.scrollBy(-delta);
        }
        return this.contains(mousePos);
    }

    @Override
    public boolean handleKeyInput(int keyCode, int scanCode, int modifiers, boolean isCharTyped) {
        boolean itemClicked = false;
        for (ScrollableListItem item : this.getItems()) {
            if (!item.isVisible()) continue;
            itemClicked = itemClicked || item.handleKeyInput(keyCode, scanCode, modifiers, isCharTyped);
        }
        return itemClicked || ItrUtil.orMapAll(ItrUtil.getAllOfType(KeyInputListener.class, this.components, this.topCover.components, this.bottomCover.components), e -> e.handleKeyInput(keyCode, scanCode, modifiers, isCharTyped));
    }

    @Override
    public void renderHover(Vector2D mouse) {
        this.getItems().forEach(i -> i.renderHover(mouse));
        ItrUtil.getAllOfType(HoverComponent.class, this.components, this.topCover.components, this.bottomCover.components).forEach(i -> i.renderHover(mouse));
    }

    public static class ScrollBar<I extends ScrollableListItem<I>>
    extends Component
    implements MouseInputListener {
        private final ScrollableList<I> parentList;
        public double barWidth = 11.0;
        public Color backgroundColor = Color.DARK_GRAY;
        public Color hoverColor = new Color(180, 180, 180);
        public Color clickedColor = new Color(101, 101, 101);
        private int scrollAmount = 0;
        private int clickedYOffset = -1;

        public ScrollBar(ScrollableList<I> parentList) {
            this.parentList = parentList;
        }

        @Override
        public void render(Vector2D mouse) {
            Renderer2D.drawRectWithEdge(this.getDisplayedPos(), this.getDisplayedSize(), 1.0, this.backgroundColor, Color.BLACK);
            BoundingBox2D scrollButtonBB = this.getScrollButtonBB();
            Renderer2D.drawRect(scrollButtonBB.getMin().add(1.0), scrollButtonBB.getSize().sub(2.0), this.clickedYOffset != -1 ? this.clickedColor : (this.contains(mouse) ? this.hoverColor : Color.WHITE));
        }

        public BoundingBox2D getScrollButtonBB() {
            return BoundingBox2D.fromPosSize(new Vector2D(this.getDisplayedPos().getX() + 1.0, this.getDisplayedPos().getY() + (double)this.mapScrollAmountToScrollButtonPos()), new Vector2D(this.barWidth - 2.0, this.getScrollButtonHeight()));
        }

        public int mapScrollAmountToScrollButtonPos() {
            return MathUtil.map(this.scrollAmount, 0, this.parentList.totalHeight() - this.getDisplayedSize().getYI() - 2, 1, this.getDisplayedSize().getYI() - this.getScrollButtonHeight() - 1);
        }

        public int getScrollButtonHeight() {
            int totalHeight = this.parentList.totalHeight();
            if (totalHeight == 0) {
                ++totalHeight;
            }
            return Math.min(MathUtil.sqr(this.getDisplayedSize().getYI() - 2) / totalHeight, this.getDisplayedSize().getYI() - 2);
        }

        @Override
        public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
            switch (state) {
                case DOWN: {
                    if (!this.getScrollButtonBB().contains(mousePos)) break;
                    this.clickedYOffset = mousePos.getYI() - this.getScrollButtonBB().getMin().getYI();
                    break;
                }
                case DRAG: {
                    if (this.clickedYOffset == -1) break;
                    this.scrollAmount = this.mapScrollButtonPosToScrollAmount(mousePos);
                    this.constrainScrollAmountToScreen();
                    break;
                }
                case UP: {
                    if (this.clickedYOffset != -1) {
                        this.scrollAmount = this.mapScrollButtonPosToScrollAmount(mousePos);
                        this.constrainScrollAmountToScreen();
                    }
                    this.clickedYOffset = -1;
                }
            }
            return this.getScrollButtonBB().contains(mousePos);
        }

        public int mapScrollButtonPosToScrollAmount(Vector2D pos) {
            return MathUtil.map(pos.getYI() - this.clickedYOffset - this.getDisplayedPos().getYI(), 1, this.getDisplayedSize().getYI() - this.getScrollButtonHeight() - 1, 0, this.parentList.totalHeight() - this.getDisplayedSize().getYI() - 2);
        }

        public void constrainScrollAmountToScreen() {
            this.scrollAmount = MathUtil.constrain(this.scrollAmount, 0, this.parentList.totalHeight() - this.getDisplayedSize().getYI() - 2);
        }

        public void scrollBy(int delta) {
            this.scrollAmount += delta;
            this.constrainScrollAmountToScreen();
        }
    }
}

