/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.modules;

import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.modules.MPKModule;
import io.github.kurrycat.mpkmod.modules.MPKModuleConfig;
import io.github.kurrycat.mpkmod.modules.MPKModuleImpl;
import io.github.kurrycat.mpkmod.save.Serializer;
import io.github.kurrycat.mpkmod.util.ClassUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ModuleFinder {
    private static final String MODULE_FOLDER_NAME = "mpkmodules";
    private static File modDir;

    public static void init() {
        modDir = ModuleFinder.getModDir();
        if (!modDir.exists()) {
            modDir.mkdir();
        }
    }

    private static File getModDir() {
        return new File("./mods");
    }

    public static Map<MPKModuleConfig, File> findAllModules() {
        HashMap<MPKModuleConfig, File> modules = new HashMap<MPKModuleConfig, File>();
        ModuleFinder.registerModulesInFolder(modules, modDir);
        File moduleDir = new File(modDir, MODULE_FOLDER_NAME);
        if (moduleDir.exists()) {
            ModuleFinder.registerModulesInFolder(modules, moduleDir);
        }
        return modules;
    }

    private static void registerModulesInFolder(Map<MPKModuleConfig, File> modules, File folder) {
        File[] files = folder.listFiles();
        if (files == null) {
            API.LOGGER.info("Failed to search folder: " + folder.getPath() + " for modules");
            return;
        }
        block0: for (File file : files) {
            MPKModuleConfig config;
            if (!file.getName().endsWith(".jar") || (config = ModuleFinder.getConfigFromModule(file)) == null) continue;
            for (Map.Entry<MPKModuleConfig, File> e : modules.entrySet()) {
                if (!e.getKey().moduleName.equals(config.moduleName)) continue;
                API.LOGGER.info("Found duplicate module " + config.moduleName + ": " + e.getValue().getName() + " and " + file.getName() + " have the same module name");
                continue block0;
            }
            modules.put(config, file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MPKModuleConfig getConfigFromModule(File modJar) {
        MPKModuleConfig config = null;
        try (JarFile jarFile = new JarFile(modJar);){
            JarEntry entry = jarFile.getJarEntry("mpkmodule.config.json");
            if (entry == null) {
                MPKModuleConfig mPKModuleConfig = null;
                return mPKModuleConfig;
            }
            try (InputStream stream = jarFile.getInputStream(entry);){
                config = Serializer.deserialize(stream, MPKModuleConfig.class);
                return config;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return config;
    }

    public static MPKModuleImpl getAsImpl(MPKModuleConfig config, File modJar) throws Exception {
        URL[] jars = new URL[]{modJar.toURI().toURL()};
        CustomClassLoader loader = new CustomClassLoader(config.mainClass, jars, ClassUtil.ModClass.getClassLoader());
        Class<?> moduleClass = loader.loadClass(config.mainClass);
        MPKModule module = (MPKModule)moduleClass.newInstance();
        return new MPKModuleImpl(config.moduleName, module, loader);
    }

    public static class CustomClassLoader
    extends URLClassLoader {
        private final String packageName;

        public CustomClassLoader(String module, URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.packageName = module.substring(0, module.lastIndexOf("."));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (!name.startsWith(this.packageName)) {
                return super.loadClass(name, resolve);
            }
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> c = this.findClass(name);
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
    }
}

