/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.ticks;

import io.github.kurrycat.mpkmod.util.Copyable;

public class TickInput
implements Copyable<TickInput> {
    public static final int W_FLAG = 1;
    public static final int A_FLAG = 2;
    public static final int S_FLAG = 4;
    public static final int D_FLAG = 8;
    public static final int P_FLAG = 16;
    public static final int N_FLAG = 32;
    public static final int J_FLAG = 64;
    protected final int keyInputs;
    protected final int L;
    protected final int R;
    protected final float YAW;
    protected final float PITCH;
    protected final int COUNT;

    public TickInput(boolean W, boolean A, boolean S, boolean D, boolean P, boolean N, boolean J, int L, int R, float YAW, float PITCH, int COUNT) {
        this.keyInputs = (W ? 1 : 0) | (A ? 2 : 0) | (S ? 4 : 0) | (D ? 8 : 0) | (P ? 16 : 0) | (N ? 32 : 0) | (J ? 64 : 0);
        this.L = L;
        this.R = R;
        this.YAW = YAW;
        this.PITCH = PITCH;
        this.COUNT = COUNT;
    }

    public TickInput() {
        this.keyInputs = 0;
        this.L = 0;
        this.R = 0;
        this.YAW = 0.0f;
        this.PITCH = 0.0f;
        this.COUNT = 1;
    }

    public TickInput(int keyInputs, int L, int R, float YAW, float PITCH, int COUNT) {
        this.keyInputs = keyInputs;
        this.L = L;
        this.R = R;
        this.YAW = YAW;
        this.PITCH = PITCH;
        this.COUNT = COUNT;
    }

    private TickInput(TickInput other) {
        this.keyInputs = other.keyInputs;
        this.L = other.L;
        this.R = other.R;
        this.YAW = other.YAW;
        this.PITCH = other.PITCH;
        this.COUNT = other.COUNT;
    }

    @Override
    public TickInput copy() {
        return new TickInput(this);
    }

    public String toString() {
        return (this.getW() ? "W" : "") + (this.getA() ? "A" : "") + (this.getS() ? "S" : "") + (this.getD() ? "D" : "") + (this.getP() ? "P" : "") + (this.getN() ? "N" : "") + (this.getJ() ? "J" : "") + ",L:" + this.getL() + ",R:" + this.getR() + ",YAW:" + this.getYaw() + ",PITCH:" + this.getPitch() + ",COUNT:" + this.getCount();
    }

    public boolean getW() {
        return this.get(1);
    }

    public boolean getA() {
        return this.get(2);
    }

    public boolean getS() {
        return this.get(4);
    }

    public boolean getD() {
        return this.get(8);
    }

    public boolean getP() {
        return this.get(16);
    }

    public boolean getN() {
        return this.get(32);
    }

    public boolean getJ() {
        return this.get(64);
    }

    public int getL() {
        return this.L;
    }

    public int getR() {
        return this.R;
    }

    public float getYaw() {
        return this.YAW;
    }

    public float getPitch() {
        return this.PITCH;
    }

    public int getCount() {
        return this.COUNT;
    }

    public boolean get(int flag) {
        return (this.keyInputs & flag) != 0;
    }

    public int getKeyInputs() {
        return this.keyInputs;
    }
}

