/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class ItrUtil {
    public static <T> boolean orMap(Iterable<T> list, ListElementSupplier<T> elementSupplier) {
        for (T e : list) {
            if (!elementSupplier.apply(e)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean orMapAll(Iterable<T> list, ListElementSupplier<T> elementSupplier) {
        boolean b = false;
        for (T e : list) {
            if (!elementSupplier.apply(e)) continue;
            b = true;
        }
        return b;
    }

    public static <T> ArrayList<T> getAllOfType(Class<T> tClass, ArrayList<?> list) {
        return list.stream().filter(Objects::nonNull).filter(tClass::isInstance).map(c -> c).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> ArrayList<T> getAllOfType(Class<T> tClass, Object ... list) {
        return Arrays.stream(list).filter(Objects::nonNull).filter(tClass::isInstance).map(c -> c).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> ArrayList<T> getAllOfType(Class<T> tClass, ArrayList<?> ... lists) {
        ArrayList<T> returnList = new ArrayList<T>();
        for (ArrayList<?> list : lists) {
            returnList.addAll(ItrUtil.getAllOfType(tClass, list));
        }
        return returnList;
    }

    @SafeVarargs
    public static <T> ArrayList<T> joinLists(ArrayList<T> ... lists) {
        if (lists.length == 0) {
            return null;
        }
        ArrayList<T> returnList = new ArrayList<T>(lists[0]);
        for (int i = 1; i < lists.length; ++i) {
            if (lists[i] == null) continue;
            returnList.addAll(lists[i]);
        }
        return returnList;
    }

    @FunctionalInterface
    public static interface ListElementSupplier<T> {
        public boolean apply(T var1);
    }
}

