/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.util;

import io.github.kurrycat.mpkmod.gui.infovars.InfoString;
import io.github.kurrycat.mpkmod.util.Copyable;
import io.github.kurrycat.mpkmod.util.FormatDecimals;
import io.github.kurrycat.mpkmod.util.MathUtil;

@InfoString.DataClass
public class Vector3D
implements Copyable<Vector3D>,
FormatDecimals {
    public static final Vector3D ZERO = new Vector3D(0.0, 0.0, 0.0);
    private double x;
    private double y;
    private double z;

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @InfoString.Getter
    public double getX() {
        return this.x;
    }

    public Vector3D setX(double x) {
        this.x = x;
        return this;
    }

    public int getXI() {
        return (int)this.x;
    }

    @InfoString.Getter
    public double getY() {
        return this.y;
    }

    public Vector3D setY(double y) {
        this.y = y;
        return this;
    }

    public int getYI() {
        return (int)this.y;
    }

    @InfoString.Getter
    public double getZ() {
        return this.z;
    }

    public Vector3D setZ(double z) {
        this.z = z;
        return this;
    }

    public int getZI() {
        return (int)this.z;
    }

    public Vector3D add(Vector3D v) {
        return new Vector3D(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vector3D add(double x, double y, double z) {
        return new Vector3D(this.x + x, this.y + y, this.z + z);
    }

    public Vector3D add(double v) {
        return new Vector3D(this.x + v, this.y + v, this.z + v);
    }

    public Vector3D sub(Vector3D v) {
        return new Vector3D(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public Vector3D sub(double v) {
        return new Vector3D(this.x - v, this.y - v, this.z - v);
    }

    public Vector3D mult(double v) {
        return new Vector3D(this.x * v, this.y * v, this.z * v);
    }

    public double lengthSqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double length() {
        return Math.sqrt(this.lengthSqr());
    }

    @InfoString.Getter
    public double lengthXZ() {
        return Math.sqrt(this.lengthXZSqr());
    }

    @InfoString.Getter
    public double angleXZ() {
        return Math.toDegrees(Math.atan2(this.x, this.z));
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    @Override
    public Vector3D copy() {
        return new Vector3D(this.x, this.y, this.z);
    }

    public Vector3D round() {
        return new Vector3D(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public Vector3D floor() {
        return new Vector3D(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public Vector3D toInts() {
        return new Vector3D((int)this.x, (int)this.y, (int)this.z);
    }

    public double lengthXZSqr() {
        return this.x * this.x + this.z * this.z;
    }

    public int hashCode() {
        return Double.hashCode(this.x) + Double.hashCode(this.y) + Double.hashCode(this.z);
    }

    public boolean equals(Object obj) {
        return obj instanceof Vector3D && this.x == ((Vector3D)obj).x && this.y == ((Vector3D)obj).y && this.z == ((Vector3D)obj).z;
    }

    public Vector3D abs() {
        return new Vector3D(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    @Override
    public String formatDecimals(int decimals, boolean keepZeros) {
        return "[" + MathUtil.formatDecimals(this.x, decimals, keepZeros) + "," + MathUtil.formatDecimals(this.y, decimals, keepZeros) + "," + MathUtil.formatDecimals(this.z, decimals, keepZeros) + "]";
    }
}

