/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpknetapi.common.network;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class MPKByteBuf {
    private final ByteBuf buf;

    public MPKByteBuf(ByteBuf buf) {
        this.buf = buf;
    }

    public int readVarInt() {
        byte currentByte;
        int result = 0;
        int byteCount = 0;
        do {
            currentByte = this.buf.readByte();
            result |= (currentByte & 0x7F) << byteCount++ * 7;
            if (byteCount <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((currentByte & 0x80) == 128);
        return result;
    }

    public void writeVarInt(int input) {
        while ((input & 0xFFFFFF80) != 0) {
            this.buf.writeByte(input & 0x7F | 0x80);
            input >>>= 7;
        }
        this.buf.writeByte(input);
    }

    public String readString() {
        int maxLength = Short.MAX_VALUE;
        int strLength = this.readVarInt();
        if (strLength > maxLength) {
            throw new DecoderException("The received encoded string buffer length is longer than maximum allowed (" + strLength + " > " + maxLength + ")");
        }
        if (strLength < 0) {
            throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
        }
        String string = this.buf.toString(this.buf.readerIndex(), strLength, StandardCharsets.UTF_8);
        this.buf.readerIndex(this.buf.readerIndex() + strLength);
        if (string.length() > maxLength) {
            throw new DecoderException("The received string length is longer than maximum allowed (" + strLength + " > " + maxLength + ")");
        }
        return string;
    }

    public void writeString(String string) {
        byte[] bs = string.getBytes(StandardCharsets.UTF_8);
        if (bs.length > Short.MAX_VALUE) {
            throw new EncoderException("String too big (was " + string.length() + " bytes encoded, max " + Short.MAX_VALUE + ")");
        }
        this.writeVarInt(bs.length);
        this.buf.writeBytes(bs);
    }

    public List<String> readStringList() {
        int size = this.readVarInt();
        ArrayList<String> output = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            output.add(this.readString());
        }
        return output;
    }

    public void writeStringList(List<String> strings) {
        this.writeVarInt(strings.size());
        strings.forEach(this::writeString);
    }

    public ByteBuf getBuf() {
        return this.buf;
    }
}

