/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.compatibility.MCClasses;

import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.FunctionHolder;
import io.github.kurrycat.mpkmod.gui.components.ComponentHolder;
import io.github.kurrycat.mpkmod.util.Colors;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;
import java.util.Optional;

public class FontRenderer {
    public static double DEFAULT_FONT_SIZE = 9.0;

    public static void drawCenteredString(String text, Vector2D pos, Color color, boolean shadow) {
        FontRenderer.drawString(text, pos.sub(FontRenderer.getStringSize(text).div(2.0)), color, shadow);
    }

    public static void drawCenteredMonospaceString(String text, Vector2D pos, Color color, boolean shadow) {
        FontRenderer.drawMonospaceString(text, pos.sub(FontRenderer.getStringSize(text).div(2.0)), color, shadow);
    }

    public static void drawString(String text, Vector2D pos, Color color, boolean shadow) {
        FontRenderer.drawString(text, pos, color, DEFAULT_FONT_SIZE, shadow);
    }

    public static void drawMonospaceString(String text, Vector2D pos, Color color, boolean shadow) {
        FontRenderer.drawMonospaceString(text, pos, color, DEFAULT_FONT_SIZE, shadow);
    }

    public static Vector2D getStringSize(String text) {
        return FontRenderer.getStringSize(text, DEFAULT_FONT_SIZE);
    }

    public static void drawString(String text, Vector2D pos, Color color, double fontSize, boolean shadow) {
        FontRenderer.drawString(text, pos.getX(), pos.getY(), color, fontSize, shadow);
    }

    public static void drawMonospaceString(String text, Vector2D pos, Color color, double fontSize, boolean shadow) {
        FontRenderer.drawMonospaceString(text, pos.getX(), pos.getY(), color, fontSize, shadow);
    }

    public static Vector2D getStringSize(String text, double fontSize) {
        return Interface.get().map(f -> f.getStringSize(text, fontSize)).orElse(Vector2D.ZERO.copy());
    }

    public static void drawString(String text, double x, double y, Color color, double fontSize, boolean shadow) {
        Interface.get().ifPresent(f -> f.drawString(Colors.RESET.getCode() + text, x, y, color, fontSize, shadow));
    }

    public static void drawMonospaceString(String text, double x, double y, Color color, double fontSize, boolean shadow) {
        int i = 0;
        while (i < text.length()) {
            int finalI = i++;
            Interface.get().ifPresent(f -> {
                if (text.charAt(finalI) == ' ') {
                    return;
                }
                f.drawString(Colors.RESET.getCode() + text.charAt(finalI), x + (double)finalI * fontSize * 6.0 / 9.0, y, color, fontSize, shadow);
            });
        }
    }

    public static void drawCenteredString(String text, ComponentHolder parent, Color color, boolean shadow) {
        FontRenderer.drawCenteredString(text, parent, color, DEFAULT_FONT_SIZE, shadow);
    }

    public static void drawCenteredString(String text, ComponentHolder parent, Color color, double fontSize, boolean shadow) {
        Vector2D stringSize = FontRenderer.getStringSize(text);
        FontRenderer.drawString(text, parent.getDisplayedPos().getX() + parent.getDisplayedSize().getX() / 2.0 - stringSize.getX() / 2.0, parent.getDisplayedPos().getY() + parent.getDisplayedSize().getY() / 2.0 + 1.0 - stringSize.getY() / 2.0, color, fontSize, shadow);
    }

    public static void drawRightString(String text, Vector2D pos, Color color, boolean shadow) {
        FontRenderer.drawString(text, pos.sub(FontRenderer.getStringSize(text)), color, shadow);
    }

    public static void drawRightCenteredString(String text, Vector2D pos, Color color, boolean shadow) {
        Vector2D s = FontRenderer.getStringSize(text);
        FontRenderer.drawString(text, pos.sub(s.getX(), s.getY() / 2.0), color, shadow);
    }

    public static void drawLeftCenteredString(String text, Vector2D pos, Color color, boolean shadow) {
        FontRenderer.drawString(text, pos.sub(0.0, FontRenderer.getStringSize(text).getY() / 2.0), color, shadow);
    }

    public static void drawLeftCenteredMonospaceString(String text, Vector2D pos, Color color, boolean shadow) {
        FontRenderer.drawMonospaceString(text, pos.sub(0.0, FontRenderer.getStringSize(text).getY() / 2.0), color, shadow);
    }

    public static interface Interface
    extends FunctionHolder {
        public static Optional<Interface> get() {
            return API.getFunctionHolder(Interface.class);
        }

        public void drawString(String var1, double var2, double var4, Color var6, double var7, boolean var9);

        public Vector2D getStringSize(String var1, double var2);
    }
}

