/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.compatibility.fabric_1_21_6;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.FunctionHolder;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Keyboard;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Minecraft;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Profiler;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer3D;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.SoundManager;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.WorldInteraction;
import io.github.kurrycat.mpkmod.compatibility.fabric_1_21_6.MPKGuiScreen;
import io.github.kurrycat.mpkmod.compatibility.fabric_1_21_6.MPKMod;
import io.github.kurrycat.mpkmod.compatibility.fabric_1_21_6.mixin.KeyBindingAccessor;
import io.github.kurrycat.mpkmod.compatibility.fabric_1_21_6.network.DataCustomPayload;
import io.github.kurrycat.mpkmod.util.BoundingBox3D;
import io.github.kurrycat.mpkmod.util.Debug;
import io.github.kurrycat.mpkmod.util.Vector2D;
import io.github.kurrycat.mpkmod.util.Vector3D;
import io.github.kurrycat.mpknetapi.common.network.packet.MPKPacket;
import java.awt.Color;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10209;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_11256;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5321;
import net.minecraft.class_642;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_8030;
import net.minecraft.class_8710;
import net.minecraft.class_9974;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class FunctionCompatibility
implements FunctionHolder,
SoundManager.Interface,
WorldInteraction.Interface,
Renderer3D.Interface,
Renderer2D.Interface,
FontRenderer.Interface,
Minecraft.Interface,
Keyboard.Interface,
Profiler.Interface {
    public static final Set<Integer> pressedButtons = new HashSet<Integer>();
    public class_332 drawContext = null;

    @Override
    public void playButtonSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    @Override
    public List<BoundingBox3D> getCollisionBoundingBoxes(Vector3D blockPosVector) {
        Vector3D blockPosVec = blockPosVector.copy();
        class_2338 blockPos = new class_2338(blockPosVec.getXI(), blockPosVec.getYI(), blockPosVec.getZI());
        if (class_310.method_1551().field_1687 == null) {
            return null;
        }
        ArrayList<BoundingBox3D> boundingBoxes = new ArrayList<BoundingBox3D>();
        class_2680 blockState = class_310.method_1551().field_1687.method_8320(blockPos);
        blockState.method_26220((class_1922)class_310.method_1551().field_1687, blockPos).method_1097().method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> boundingBoxes.add(new BoundingBox3D(new Vector3D(minX, minY, minZ), new Vector3D(maxX, maxY, maxZ)).move(blockPosVec)));
        return boundingBoxes;
    }

    @Override
    public Vector3D getLookingAt() {
        if (class_310.method_1551().method_1560() == null) {
            return null;
        }
        class_239 hitResult = class_310.method_1551().method_1560().method_5745(20.0, 0.0f, false);
        if (hitResult instanceof class_3965) {
            class_2338 blockPos = ((class_3965)hitResult).method_17777();
            return new Vector3D(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
        }
        return null;
    }

    @Override
    public String getBlockName(Vector3D blockPos) {
        class_2338 blockpos = new class_2338(blockPos.getXI(), blockPos.getYI(), blockPos.getZI());
        if (class_310.method_1551().field_1687 == null) {
            return null;
        }
        return ((class_5321)class_7923.field_41175.method_29113((Object)class_310.method_1551().field_1687.method_8320(blockpos).method_26204()).get()).method_29177().toString();
    }

    @Override
    public HashMap<String, String> getBlockProperties(Vector3D blockPos) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (class_310.method_1551().field_1687 == null) {
            return properties;
        }
        class_2338 blockpos = new class_2338(blockPos.getXI(), blockPos.getYI(), blockPos.getZI());
        class_2680 blockState = class_310.method_1551().field_1687.method_8320(blockpos);
        blockState.method_11656().forEach((key, value) -> properties.put(key.method_11899(), class_156.method_650((class_2769)key, (Object)value)));
        return null;
    }

    public String getLookingAtBlock() {
        if (class_310.method_1551().method_1560() == null) {
            return null;
        }
        class_239 hitResult = class_310.method_1551().method_1560().method_5745(20.0, 0.0f, false);
        if (hitResult.method_17783() == class_239.class_240.field_1332 && class_310.method_1551().field_1687 != null) {
            return ((class_5321)class_7923.field_41175.method_29113((Object)class_310.method_1551().field_1687.method_8320(((class_3965)hitResult).method_17777()).method_26204()).get()).method_29177().method_42094();
        }
        return null;
    }

    @Override
    public void drawBox(BoundingBox3D bb, Color color, float partialTicks) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        RenderSystem.lineWidth((float)1.0f);
        float minX = (float)bb.minX();
        float minY = (float)bb.minY();
        float minZ = (float)bb.minZ();
        float maxX = (float)bb.maxX();
        float maxY = (float)bb.maxY();
        float maxZ = (float)bb.maxZ();
        class_9974.method_62294((class_4587)MPKMod.INSTANCE.matrixStack, (class_4588)class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_49047()), (float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
    }

    @Override
    public void drawRect(Vector2D pos, Vector2D size, Color color) {
        if (this.drawContext == null) {
            return;
        }
        this.drawContext.method_25294((int)pos.getX(), (int)pos.getY(), (int)(pos.getX() + size.getX()), (int)(pos.getY() + size.getY()), color.getRGB());
    }

    @Override
    public void drawLines(Collection<Vector2D> points, Color color) {
        if (points.size() < 2) {
            Debug.stacktrace("At least two points expected, got: " + points.size());
            return;
        }
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        class_1041 window = class_310.method_1551().method_22683();
        class_8030 bounds = new class_8030(0, 0, window.method_4486(), window.method_4502());
        this.drawContext.field_59826.method_70919((class_11244)new PointsRenderState(points, r, g, b, a, class_11256.method_71535((int)bounds.method_49620(), (int)bounds.method_49618(), (int)bounds.method_49621(), (int)bounds.method_49619(), (class_8030)this.drawContext.field_44659.method_70863()), this.drawContext.field_44659.method_70863()));
    }

    @Override
    public Vector2D getScaledSize() {
        return new Vector2D(class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502());
    }

    @Override
    public Vector2D getScreenSize() {
        return new Vector2D(class_310.method_1551().method_22683().method_4480(), class_310.method_1551().method_22683().method_4507());
    }

    @Override
    public void enableScissor(double x, double y, double w, double h) {
        int x1 = (int)x;
        int y1 = (int)y;
        int x2 = (int)(x + w);
        int y2 = (int)(y + h);
        this.drawContext.method_44379(x1, y1, x2, y2);
    }

    @Override
    public void disableScissor() {
        try {
            this.drawContext.method_44380();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void clearScissors() {
        boolean clearedAll = false;
        while (!clearedAll) {
            try {
                this.drawContext.method_44380();
            }
            catch (IllegalStateException e) {
                clearedAll = true;
            }
        }
    }

    @Override
    public boolean scissorContains(Vector2D point) {
        return this.drawContext.method_58135(point.getXI(), point.getYI());
    }

    @Override
    public void drawString(String text, double x, double y, Color color, double fontSize, boolean shadow) {
        if (this.drawContext == null) {
            return;
        }
        Matrix3x2fStack matrixStack = this.drawContext.method_51448();
        matrixStack.pushMatrix();
        matrixStack.translate((float)x, (float)y);
        Objects.requireNonNull(class_310.method_1551().field_1772);
        double scale = fontSize / 9.0;
        matrixStack.scale((float)scale, (float)scale);
        this.drawContext.method_51433(class_310.method_1551().field_1772, text, 0, 0, color.getRGB(), shadow);
        matrixStack.popMatrix();
    }

    @Override
    public Vector2D getStringSize(String text, double fontSize) {
        float f = class_310.method_1551().field_1772.method_1727(text);
        Objects.requireNonNull(class_310.method_1551().field_1772);
        return new Vector2D(f * (float)(fontSize / 9.0), (float)fontSize);
    }

    @Override
    public String getIP() {
        class_642 d = class_310.method_1551().method_1558();
        if (d == null) {
            return "Multiplayer";
        }
        return d.field_3761;
    }

    @Override
    public String getFPS() {
        String[] split = class_310.method_1551().field_1770.split(" ");
        if (split.length == 0) {
            return "Error";
        }
        return split[0];
    }

    @Override
    public void displayGuiScreen(io.github.kurrycat.mpkmod.gui.MPKGuiScreen screen) {
        class_310.method_1551().method_1507((class_437)(screen == null ? null : new MPKGuiScreen(screen)));
    }

    @Override
    public String getCurrentGuiScreen() {
        class_437 curr = class_310.method_1551().field_1755;
        if (curr == null) {
            return null;
        }
        if (curr instanceof MPKGuiScreen) {
            String id = ((MPKGuiScreen)curr).eventReceiver.getID();
            if (id == null) {
                id = "unknown";
            }
            return id;
        }
        return curr.getClass().getSimpleName();
    }

    @Override
    public String getUserName() {
        if (class_310.method_1551().field_1724 == null) {
            return null;
        }
        return class_310.method_1551().field_1724.method_5477().getString();
    }

    @Override
    public void copyToClipboard(String content) {
        class_310.method_1551().field_1774.method_1455(content);
    }

    @Override
    public boolean setInputs(Float yaw, boolean relYaw, Float pitch, boolean relPitch, int pressedInputs, int releasedInputs, int L, int R) {
        int i;
        if (!Minecraft.isSingleplayer()) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        class_315 op = class_310.method_1551().field_1690;
        float prevYaw = player.method_36454();
        float prevPitch = player.method_36455();
        if (yaw != null) {
            player.method_36456(relYaw ? player.method_36454() + yaw.floatValue() : yaw.floatValue());
            player.field_5982 += player.method_36454() - prevYaw;
        }
        if (pitch != null) {
            player.method_36457(relPitch ? player.method_36455() + pitch.floatValue() : pitch.floatValue());
            player.method_36457(class_3532.method_15363((float)player.method_36455(), (float)-90.0f, (float)90.0f));
            player.field_6004 += player.method_36455() - prevPitch;
            player.field_6004 = class_3532.method_15363((float)player.field_6004, (float)-90.0f, (float)90.0f);
        }
        if (player.method_5854() != null) {
            player.method_5854().method_5644((class_1297)player);
        }
        class_304[] keys = new class_304[]{op.field_1894, op.field_1913, op.field_1881, op.field_1849, op.field_1867, op.field_1832, op.field_1903};
        for (i = 0; i < keys.length; ++i) {
            if ((releasedInputs & 1 << i) != 0) {
                class_304.method_1416((class_3675.class_306)((KeyBindingAccessor)keys[i]).getBoundKey(), (boolean)false);
            }
            if ((pressedInputs & 1 << i) == 0) continue;
            class_304.method_1416((class_3675.class_306)((KeyBindingAccessor)keys[i]).getBoundKey(), (boolean)true);
            class_304.method_1420((class_3675.class_306)((KeyBindingAccessor)keys[i]).getBoundKey());
        }
        class_304.method_1416((class_3675.class_306)((KeyBindingAccessor)op.field_1886).getBoundKey(), (L > 0 ? 1 : 0) != 0);
        for (i = 0; i < L; ++i) {
            class_304.method_1420((class_3675.class_306)((KeyBindingAccessor)op.field_1886).getBoundKey());
        }
        class_304.method_1416((class_3675.class_306)((KeyBindingAccessor)op.field_1904).getBoundKey(), (R > 0 ? 1 : 0) != 0);
        for (i = 0; i < R; ++i) {
            class_304.method_1420((class_3675.class_306)((KeyBindingAccessor)op.field_1904).getBoundKey());
        }
        return true;
    }

    @Override
    public boolean isF3Enabled() {
        return class_310.method_1551().method_53526().method_53536();
    }

    @Override
    public void sendPacket(MPKPacket packet) {
        ClientPlayNetworking.send((class_8710)new DataCustomPayload(packet.getData()));
    }

    @Override
    public List<Integer> getPressedButtons() {
        return new ArrayList<Integer>(pressedButtons);
    }

    @Override
    public void startSection(String name) {
        class_10209.method_64146().method_15396(name);
    }

    @Override
    public void endStartSection(String name) {
        class_10209.method_64146().method_15405(name);
    }

    @Override
    public void endSection() {
        class_10209.method_64146().method_15407();
    }

    private static final class PointsRenderState
    extends Record
    implements class_11244 {
        private final Collection<Vector2D> points;
        private final int r;
        private final int g;
        private final int b;
        private final int a;
        private final class_8030 bounds;
        private final class_8030 scissor;

        private PointsRenderState(Collection<Vector2D> points, int r, int g, int b, int a, class_8030 bounds, class_8030 scissor) {
            this.points = points;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.bounds = bounds;
            this.scissor = scissor;
        }

        @Nullable
        public class_8030 comp_4274() {
            return this.bounds;
        }

        public void method_70917(class_4588 consumer, float depth) {
            for (Vector2D p : this.points) {
                consumer.method_22912((float)p.getX(), (float)p.getY(), 0.0f).method_1336(this.r, this.g, this.b, this.a);
            }
        }

        public RenderPipeline comp_4055() {
            return class_10799.field_56879;
        }

        public class_11231 comp_4056() {
            return class_11231.method_70899();
        }

        @Nullable
        public class_8030 comp_4069() {
            return this.scissor;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PointsRenderState.class, "points;r;g;b;a;bounds;scissor", "points", "r", "g", "b", "a", "bounds", "scissor"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PointsRenderState.class, "points;r;g;b;a;bounds;scissor", "points", "r", "g", "b", "a", "bounds", "scissor"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PointsRenderState.class, "points;r;g;b;a;bounds;scissor", "points", "r", "g", "b", "a", "bounds", "scissor"}, this, o);
        }

        public Collection<Vector2D> points() {
            return this.points;
        }

        public int r() {
            return this.r;
        }

        public int g() {
            return this.g;
        }

        public int b() {
            return this.b;
        }

        public int a() {
            return this.a;
        }

        public class_8030 scissor() {
            return this.scissor;
        }
    }
}

