/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.compatibility.fabric_1_21_6;

import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.KeyBinding;
import io.github.kurrycat.mpkmod.compatibility.fabric_1_21_6.EventHandler;
import io.github.kurrycat.mpkmod.compatibility.fabric_1_21_6.FunctionCompatibility;
import io.github.kurrycat.mpkmod.compatibility.fabric_1_21_6.network.DataCustomPayload;
import io.github.kurrycat.mpknetapi.common.network.packet.MPKPacket;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_155;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class MPKMod
implements ModInitializer {
    public static final MPKMod INSTANCE = new MPKMod();
    public static Map<String, class_304> keyBindingMap = new HashMap<String, class_304>();
    public final EventHandler eventHandler = new EventHandler();
    public class_4587 matrixStack;

    public void onInitialize() {
        API.LOGGER.info("Loading MPK Mod 2.0");
        API.preInit(this.getClass());
        this.registerKeybindingsFromGUIs();
        HudRenderCallback.EVENT.register(this.eventHandler::onInGameOverlayRender);
        ClientTickEvents.START_CLIENT_TICK.register(this.eventHandler::onClientTickStart);
        ClientTickEvents.END_CLIENT_TICK.register(this.eventHandler::onClientTickEnd);
        ClientPlayConnectionEvents.JOIN.register(this.eventHandler::onServerConnect);
        ClientPlayConnectionEvents.DISCONNECT.register(this.eventHandler::onServerDisconnect);
        DataCustomPayload.registerServerboundPayload();
        ClientPlayNetworking.registerGlobalReceiver(DataCustomPayload.registerClientboundPayload(), (payload, context) -> {
            MPKPacket packet = MPKPacket.handle(API.PACKET_LISTENER_CLIENT, payload.data(), null);
            if (packet != null) {
                API.Events.onPluginMessage(packet);
            }
        });
    }

    private void registerKeybindingsFromGUIs() {
        API.guiScreenMap.forEach((id, guiScreen) -> {
            if (guiScreen.shouldCreateKeyBind()) {
                this.registerKeyBinding((String)id);
            }
        });
        API.keyBindingMap.forEach((id, consumer) -> this.registerKeyBinding((String)id));
        keyBindingMap.forEach((id, key) -> KeyBindingHelper.registerKeyBinding((class_304)key));
    }

    public void registerKeyBinding(String id) {
        class_304 keyBinding = new class_304("mpkmod.key." + id + ".desc", -1, "MPK Mod");
        keyBindingMap.put(id, keyBinding);
    }

    public void init() {
        API.LOGGER.info(API.COMPATIBILITY_MARKER, "Registering compatibility functions...");
        API.registerFunctionHolder(new FunctionCompatibility());
        API.LOGGER.info(API.COMPATIBILITY_MARKER, "Registered compatibility functions.");
        this.registerKeyBindings();
        API.init(class_155.method_16673().comp_4025());
        API.Events.onLoadComplete();
    }

    private void registerKeyBindings() {
        for (class_304 k : class_310.method_1551().field_1690.field_1839) {
            new KeyBinding(() -> k.method_16007().getString(), k.method_1431(), () -> ((class_304)k).method_1434());
        }
        API.LOGGER.info(API.COMPATIBILITY_MARKER, "Registered {} Keybindings", (Object)KeyBinding.getKeyMap().size());
    }
}

