/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.Minecraft;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.components.ComponentHolder;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;

public abstract class MPKGuiScreen
extends ComponentHolder {
    private boolean initialized = false;
    private String id = null;

    public final String getID() {
        return this.id;
    }

    public final MPKGuiScreen setID(String id) {
        this.id = id;
        return this;
    }

    public Vector2D getScreenSize() {
        return this.getDisplayedSize();
    }

    public final void onInit() {
        this.setSize(Renderer2D.getScaledSize());
        this.setRoot(this);
        if (!this.initialized || this.resetOnOpen()) {
            this.onGuiInit();
        }
        this.initialized = true;
    }

    public boolean resetOnOpen() {
        return true;
    }

    public void onGuiInit() {
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void onGuiClosed() {
    }

    public final void onResize(int width, int height) {
        this.setSize(new Vector2D(width, height));
        this.onGuiResized(this.size);
    }

    public void onGuiResized(Vector2D screenSize) {
    }

    public void onKeyEvent(int keyCode, int scanCode, int modifiers, boolean pressed) {
    }

    public void onMouseClicked(Vector2D mouse, int mouseButton) {
    }

    public void onMouseClickMove(Vector2D mouse, int mouseButton, long timeSinceLastClick) {
    }

    public void onMouseReleased(Vector2D mouse, int mouseButton) {
    }

    public void onMouseScroll(Vector2D mousePos, int delta) {
    }

    public final void drawScreen(Vector2D mouse, float partialTicks) {
        this.render(mouse, partialTicks);
        Renderer2D.endFrame();
    }

    public void render(Vector2D mouse, float partialTicks) {
    }

    public final void drawDefaultBackground() {
        Renderer2D.drawRect(Vector2D.ZERO, this.size.add(2.0), new Color(16, 16, 16, 140));
    }

    public boolean shouldCreateKeyBind() {
        return false;
    }

    public void onKeybindPressed() {
        Minecraft.displayGuiScreen(this);
    }

    public final void close() {
        Minecraft.displayGuiScreen(null);
    }
}

