/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import io.github.kurrycat.mpkmod.util.Vector2D;

public enum Anchor {
    CENTER(0.5, 0.5, false, false),
    CENTER_LEFT(0.0, 0.5, false, false),
    CENTER_RIGHT(1.0, 0.5, true, false),
    TOP_LEFT(0.0, 0.0, false, false),
    TOP_RIGHT(1.0, 0.0, true, false),
    TOP_CENTER(0.5, 0.0, false, false),
    BOTTOM_LEFT(0.0, 1.0, false, true),
    BOTTOM_RIGHT(1.0, 1.0, true, true),
    BOTTOM_CENTER(0.5, 1.0, false, true);

    public final Vector2D multiplier;
    public final Vector2D origin;
    public final boolean invertedX;
    public final boolean invertedY;

    private Anchor(double originX, double originY, boolean invertedX, boolean invertedY) {
        this.origin = new Vector2D(originX, originY);
        this.multiplier = new Vector2D(invertedX ? -1.0 : 1.0, invertedY ? -1.0 : 1.0);
        this.invertedX = invertedX;
        this.invertedY = invertedY;
    }

    public static Anchor fromPos(Vector2D pos) {
        if (pos.getX() < 0.0) {
            if (pos.getY() < 0.0) {
                return BOTTOM_RIGHT;
            }
            return TOP_RIGHT;
        }
        if (pos.getY() < 0.0) {
            return BOTTOM_LEFT;
        }
        return TOP_LEFT;
    }

    public Vector2D transformVec(Vector2D vec) {
        return vec.mult(this.multiplier);
    }

    public Vector2D getOriginPos(Vector2D size) {
        return size.mult(this.origin);
    }
}

