/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.SoundManager;
import io.github.kurrycat.mpkmod.gui.Theme;
import io.github.kurrycat.mpkmod.gui.components.Component;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseInputListener;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;

public class CheckButton
extends Component
implements MouseInputListener {
    public CheckButtonCallback checkButtonCallback;
    public Color checkedColor = Theme.lightBackground;
    public Color normalColor = Theme.darkBackground;
    public Color disabledColor = Theme.disabledBackground;
    public Color textColor = Theme.defaultText;
    public Color disabledTextColor = Theme.disabledText;
    private boolean isChecked;
    public boolean enabled = true;

    public CheckButton(Vector2D pos, CheckButtonCallback checkButtonCallback) {
        this(pos, false, checkButtonCallback);
    }

    public CheckButton(Vector2D pos, boolean checked, CheckButtonCallback checkButtonCallback) {
        this.setPos(pos);
        this.setSize(new Vector2D(11.0, 11.0));
        this.isChecked = checked;
        this.checkButtonCallback = checkButtonCallback;
    }

    public CheckButton(Vector2D pos) {
        this(pos, checked -> {});
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean checked) {
        this.isChecked = checked;
    }

    @Override
    public void render(Vector2D mouse) {
        Color color = this.enabled ? this.normalColor : this.disabledColor;
        Renderer2D.drawRectWithEdge(this.getDisplayedPos(), this.getDisplayedSize(), 1.0, color, color);
        if (this.isChecked()) {
            FontRenderer.drawString("x", this.getDisplayedPos().add(new Vector2D(3.0, 1.0)), this.enabled ? this.textColor : this.disabledTextColor, false);
        }
    }

    @Override
    public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
        if (state == Mouse.State.DOWN && this.contains(mousePos)) {
            this.isChecked = !this.isChecked;
            SoundManager.playButtonSound();
            this.checkButtonCallback.apply(this.isChecked);
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface CheckButtonCallback {
        public void apply(boolean var1);
    }
}

