/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Player;
import io.github.kurrycat.mpkmod.gui.components.Plot;
import java.util.ArrayList;
import java.util.List;

public class Last45Plot
extends Plot {
    private final List<List<Double>> data = new ArrayList<List<Double>>();
    private long lastTick = -1L;

    @JsonCreator
    public Last45Plot() {
        this.minY = -100.0;
        this.maxY = 100.0;
        this.stepY = 20.0;
        this.setDataSupplier(() -> {
            if (Player.getLatest() == null) {
                return this.data;
            }
            if (this.lastTick != API.tickTime) {
                this.lastTick = API.tickTime;
                Player latest = Player.getLatest();
                Player bLatest = Player.getBeforeLatest();
                if (bLatest == null || latest == null) {
                    return this.data;
                }
                if (bLatest.jumpTick && !bLatest.keyInput.isMovingSideways() && latest.keyInput.isMovingSideways()) {
                    this.data.clear();
                    if (this.startX <= 0) {
                        for (int i = this.startX - 2; i < -1; ++i) {
                            List<Double> tick;
                            if (Player.tickHistory.size() + i < 0 || (tick = this.fromPlayer(Player.tickHistory.get(Player.tickHistory.size() + i))) == null) continue;
                            this.data.add(tick);
                        }
                    }
                } else if (this.data.size() < this.dataSize) {
                    List<Double> tick = this.fromPlayer(bLatest);
                    this.data.add(tick);
                }
            }
            return this.data;
        });
    }

    private List<Double> fromPlayer(Player p) {
        if (p == null || p.deltaMouseX == null) {
            return null;
        }
        ArrayList<Double> x = new ArrayList<Double>();
        for (int dx : p.deltaMouseX) {
            x.add(Double.valueOf(dx));
        }
        return x;
    }
}

