/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.ComponentHolder;
import io.github.kurrycat.mpkmod.gui.components.ScrollableList;
import io.github.kurrycat.mpkmod.gui.interfaces.HoverComponent;
import io.github.kurrycat.mpkmod.gui.interfaces.KeyInputListener;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseInputListener;
import io.github.kurrycat.mpkmod.gui.interfaces.MouseScrollListener;
import io.github.kurrycat.mpkmod.util.ItrUtil;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;

public abstract class ScrollableListItem<I extends ScrollableListItem<I>>
extends ComponentHolder
implements MouseInputListener,
KeyInputListener,
MouseScrollListener,
HoverComponent {
    public static final Color defaultEdgeColor = new Color(255, 255, 255, 95);
    protected ScrollableList<I> parent;

    public ScrollableListItem(ScrollableList<I> parent) {
        this.parent = parent;
        this.parent.passPositionTo(this, 0, Anchor.TOP_LEFT);
        this.setSize(new Vector2D(parent.getDisplayedSize().getX(), 50.0));
    }

    public abstract void render(int var1, Vector2D var2, Vector2D var3, Vector2D var4);

    public final void renderComponents(Vector2D mouse) {
        this.components.forEach(c -> c.render(mouse));
    }

    public final void renderDefaultBorder(Vector2D pos, Vector2D size) {
        Renderer2D.drawHollowRect(pos.add(1.0), size.sub(2.0), 1.0, defaultEdgeColor);
    }

    public final boolean isVisible() {
        return this.getDisplayedPos().getY() >= (double)(-this.getHeight()) && this.getDisplayedPos().getY() <= this.parent.content.getDisplayedPos().getY() + this.parent.content.getDisplayedSize().getY();
    }

    public int getHeight() {
        return (int)this.getDisplayedSize().getY();
    }

    public void setHeight(double height) {
        this.setSize(new Vector2D(this.parent.getDisplayedSize().getX(), height));
    }

    @Override
    public boolean handleMouseInput(Mouse.State state, Vector2D mousePos, Mouse.Button button) {
        return ItrUtil.orMap(ItrUtil.getAllOfType(MouseInputListener.class, this.components), b -> b.handleMouseInput(state, mousePos, button));
    }

    @Override
    public boolean handleMouseScroll(Vector2D mousePos, int delta) {
        return ItrUtil.orMap(ItrUtil.getAllOfType(MouseScrollListener.class, this.components), b -> b.handleMouseScroll(mousePos, delta));
    }

    @Override
    public boolean handleKeyInput(int keyCode, int scanCode, int modifiers, boolean isCharTyped) {
        return ItrUtil.orMap(ItrUtil.getAllOfType(KeyInputListener.class, this.components), b -> b.handleKeyInput(keyCode, scanCode, modifiers, isCharTyped));
    }

    @Override
    public void renderHover(Vector2D mouse) {
    }
}

