/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.components;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.components.Component;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;

public class TextRectangle
extends Component {
    public boolean leftAligned = false;
    private String text;
    private Color color;
    private Color textColor;
    public Color edgeColor = null;

    public TextRectangle(Vector2D pos, Vector2D size, String text, Color color, Color textColor) {
        this.setPos(pos);
        this.setSize(size);
        this.text = text;
        this.color = color;
        this.textColor = textColor;
    }

    @Override
    public void render(Vector2D mouse) {
        if (this.color != null) {
            Renderer2D.drawRect(this.getDisplayedPos(), this.getDisplayedSize(), this.color);
        }
        if (this.edgeColor != null) {
            Renderer2D.drawHollowRect(this.getDisplayedPos().add(1.0), this.getDisplayedSize().sub(2.0), 1.0, this.edgeColor);
        }
        if (this.leftAligned) {
            FontRenderer.drawLeftCenteredString(this.text, this.getDisplayedPos().add(new Vector2D(3.0, this.getDisplayedSize().getY() / 2.0 + 1.0)), this.textColor, false);
        } else {
            FontRenderer.drawCenteredString(this.text, this, this.textColor, false);
        }
    }

    public void setText(String text) {
        this.text = text;
    }

    public TextRectangle setColor(Color color) {
        this.color = color;
        return this;
    }

    public TextRectangle setTextColor(Color textColor) {
        this.textColor = textColor;
        return this;
    }
}

