/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.screens.options_gui;

import io.github.kurrycat.mpkmod.compatibility.MCClasses.FontRenderer;
import io.github.kurrycat.mpkmod.compatibility.MCClasses.Renderer2D;
import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.Div;
import io.github.kurrycat.mpkmod.gui.components.ScrollableList;
import io.github.kurrycat.mpkmod.gui.components.ScrollableListItem;
import io.github.kurrycat.mpkmod.gui.components.TextRectangle;
import io.github.kurrycat.mpkmod.gui.screens.options_gui.Option;
import io.github.kurrycat.mpkmod.util.Mouse;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.awt.Color;

public abstract class OptionListItem
extends ScrollableListItem<OptionListItem> {
    private static final Color optionListColorItemEdge = new Color(255, 255, 255, 95);
    private static final Color optionListColorBg = new Color(31, 31, 31, 150);
    private final Button resetButton;
    public Option option;
    protected String value;
    protected Option.ValueType type;
    protected Div hoverText;
    protected TextRectangle helpHover;

    public OptionListItem(ScrollableList<OptionListItem> parent, Option option) {
        super(parent);
        this.option = option;
        this.value = option.getValue();
        this.type = option.getType();
        this.resetButton = new Button("Reset", new Vector2D(15.0, 0.0), new Vector2D(30.0, 11.0), mouseButton -> {
            if (mouseButton == Mouse.Button.LEFT) {
                this.loadDefaultValue();
            }
        });
        this.addChild(this.resetButton, 0, Anchor.CENTER_RIGHT);
        this.helpHover = new TextRectangle(new Vector2D(0.0, 0.0), new Vector2D(11.0, 11.0), "?", null, Color.WHITE);
        this.addChild(this.helpHover, 0, Anchor.CENTER_RIGHT);
        this.hoverText = new Div();
        this.passPositionTo(this.hoverText, 4);
        this.hoverText.backgroundColor = optionListColorBg;
        this.hoverText.borderColor = optionListColorItemEdge;
        this.hoverText.setText(option.getDescription().isEmpty() ? option.getName() : option.getDescription());
        this.hoverText.setMaxWidth(0.5);
    }

    public void loadDefaultValue() {
        this.value = this.option.getDefaultValue();
        this.updateDisplayValue();
    }

    protected abstract void updateDisplayValue();

    public void update() {
        this.option.setValue(this.value);
    }

    @Override
    public int getHeight() {
        return 21;
    }

    @Override
    public void render(int index, Vector2D pos, Vector2D size, Vector2D mouse) {
        Renderer2D.drawRectWithEdge(pos, size, 1.0, optionListColorBg, optionListColorItemEdge);
        this.helpHover.render(mouse);
        FontRenderer.drawLeftCenteredString(this.option.getDisplayName().isEmpty() ? this.option.getName() : this.option.getDisplayName(), pos.add(5.0, size.getY() / 2.0), Color.WHITE, false);
        this.renderTypeSpecific(index, pos, size, mouse);
        if (this.resetButton != null) {
            this.resetButton.enabled = !this.option.getDefaultValue().equals(this.value);
            this.resetButton.render(mouse);
        }
    }

    @Override
    public void renderHover(Vector2D mouse) {
        if (mouse.isInRectBetweenPS(this.helpHover.getDisplayedPos(), this.helpHover.getDisplayedSize())) {
            this.hoverText.setCPos(this.helpHover.getDisplayedPos().sub(this.hoverText.getDisplayedSize()).constrain(this.getRoot().getDisplayedPos().add(1.0), this.getRoot().getDisplayedSize().sub(1.0)));
            this.hoverText.render(mouse);
        }
    }

    protected abstract void renderTypeSpecific(int var1, Vector2D var2, Vector2D var3, Vector2D var4);
}

