/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.gui.screens.options_gui;

import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.gui.ComponentScreen;
import io.github.kurrycat.mpkmod.gui.components.Anchor;
import io.github.kurrycat.mpkmod.gui.components.Button;
import io.github.kurrycat.mpkmod.gui.components.ScrollableList;
import io.github.kurrycat.mpkmod.gui.screens.options_gui.Option;
import io.github.kurrycat.mpkmod.gui.screens.options_gui.OptionListItem;
import io.github.kurrycat.mpkmod.gui.screens.options_gui.OptionListItemBoolean;
import io.github.kurrycat.mpkmod.gui.screens.options_gui.OptionListItemDefault;
import io.github.kurrycat.mpkmod.gui.screens.options_gui.OptionListItemInteger;
import io.github.kurrycat.mpkmod.gui.screens.options_gui.OptionListItemString;
import io.github.kurrycat.mpkmod.util.Vector2D;
import java.util.ArrayList;

public class OptionsGuiScreen
extends ComponentScreen {
    private OptionList optionList;

    @Override
    public boolean shouldCreateKeyBind() {
        return true;
    }

    @Override
    public void onGuiInit() {
        super.onGuiInit();
        this.optionList = new OptionList(new Vector2D(0.0, 16.0), new Vector2D(0.6, -40.0), new ArrayList<Option>(API.optionsMap.values()));
        this.addChild(this.optionList, 4, Anchor.TOP_CENTER);
        this.optionList.topCover.addChild(new Button("x", new Vector2D(5.0, 1.0), new Vector2D(11.0, 11.0), mouseButton -> this.close()), 0, Anchor.CENTER_RIGHT);
        this.optionList.bottomCover.setHeight(24.0, false);
        this.optionList.bottomCover.backgroundColor = null;
        this.optionList.bottomCover.addChild(new Button("Apply", new Vector2D(-2.0, 2.0), new Vector2D(100.0, 20.0), mouseButton -> this.optionList.updateAll()), 0, Anchor.BOTTOM_RIGHT, Anchor.BOTTOM_CENTER);
        this.optionList.bottomCover.addChild(new Button("Reset all", new Vector2D(2.0, 2.0), new Vector2D(100.0, 20.0), mouseButton -> this.optionList.resetAllToDefault()), 0, Anchor.BOTTOM_LEFT, Anchor.BOTTOM_CENTER);
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
        Option.saveOptionMapToJSON();
    }

    @Override
    public void render(Vector2D mouse, float partialTicks) {
        super.render(mouse, partialTicks);
        this.optionList.renderHover(mouse);
    }

    public static class OptionList
    extends ScrollableList<OptionListItem> {
        public OptionList(Vector2D pos, Vector2D size, ArrayList<Option> options) {
            this.setPos(pos);
            this.setSize(size);
            this.setTitle("Options");
            this.items.clear();
            for (Option option : options) {
                OptionListItem item;
                if (!option.shouldShowInOptionList()) continue;
                switch (option.getType()) {
                    case BOOLEAN: {
                        item = new OptionListItemBoolean(this, option);
                        break;
                    }
                    case STRING: {
                        item = new OptionListItemString(this, option);
                        break;
                    }
                    case INTEGER: {
                        item = new OptionListItemInteger(this, option);
                        break;
                    }
                    default: {
                        item = new OptionListItemDefault(this, option);
                    }
                }
                this.items.add(item);
            }
            this.scrollBar.constrainScrollAmountToScreen();
        }

        @Override
        public void render(Vector2D mouse) {
            super.render(mouse);
            this.renderComponents(mouse);
        }

        public void resetAllToDefault() {
            for (OptionListItem item : this.items) {
                item.loadDefaultValue();
            }
        }

        public void updateAll() {
            for (OptionListItem item : this.items) {
                item.update();
            }
        }
    }
}

