/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.ticks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.kurrycat.mpkmod.compatibility.API;
import io.github.kurrycat.mpkmod.ticks.TimingEntry;
import io.github.kurrycat.mpkmod.ticks.TimingInput;
import io.github.kurrycat.mpkmod.ticks.TimingStorage;
import io.github.kurrycat.mpkmod.util.MathUtil;
import io.github.kurrycat.mpkmod.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Timing {
    private final LinkedHashMap<FormatCondition, FormatString> format;
    private final TimingEntry[] timingEntries;

    @JsonCreator
    public Timing(@JsonProperty(value="format") LinkedHashMap<FormatCondition, FormatString> format, @JsonProperty(value="timingEntries") TimingEntry[] timingEntries) {
        this.format = format;
        this.timingEntries = timingEntries;
    }

    public Match match(List<TimingInput> inputList) {
        Match result = null;
        for (int i = 0; i < inputList.size() - 1; ++i) {
            Match match;
            if (!inputList.get(i).isStopTick() || inputList.get(i + 1).isStopTick() || (match = this.startsWithMatch(inputList.subList(i + 1, inputList.size()))) == null) continue;
            result = match;
        }
        return result;
    }

    private Match startsWithMatch(List<TimingInput> inputList) {
        HashMap<String, TickMS> vars = new HashMap<String, TickMS>();
        int startIndex = 0;
        for (int i = 0; i < this.timingEntries.length; ++i) {
            boolean repeatedVar = i >= 1 && this.timingEntries[i].varNameMatches(this.timingEntries[i - 1]);
            Integer matchCount = this.timingEntries[i].matches(inputList, startIndex, vars, repeatedVar);
            if (matchCount == null) {
                return null;
            }
            startIndex += matchCount.intValue();
        }
        return new Match(this.getFormatString(vars), vars.size(), inputList.size() - startIndex);
    }

    private String getFormatString(HashMap<String, TickMS> vars) {
        StringBuilder sb = new StringBuilder();
        this.format.forEach((fc, fs) -> {
            if (fc.check(vars)) {
                sb.append(fs.get(vars));
            }
        });
        return sb.toString();
    }

    public static class TickMS {
        public int tickCount;
        public Integer ms = null;

        public TickMS(int tickCount) {
            this.tickCount = tickCount;
        }

        public String getMSOrEmpty() {
            if (this.ms == null) {
                return "";
            }
            return String.valueOf(this.ms);
        }
    }

    public static class Match
    implements Comparable<Match> {
        private final int numberOfVars;
        private final int endOffset;
        public String displayString;

        private Match(String displayString, int numberOfVars, int endOffset) {
            this.displayString = displayString;
            this.numberOfVars = numberOfVars;
            this.endOffset = endOffset;
        }

        @Override
        public int compareTo(Match o) {
            if (this.endOffset != o.endOffset) {
                return Integer.compare(this.endOffset, o.endOffset);
            }
            return Integer.compare(this.numberOfVars, o.numberOfVars);
        }
    }

    public static class FormatCondition {
        OR condition;
        boolean isDefault = false;
        String checkMS = null;

        @JsonCreator
        public FormatCondition(String formatCondition) {
            if (formatCondition.startsWith("default")) {
                this.isDefault = true;
                return;
            }
            Matcher matcher = FormatString.regexPatternRaw.matcher(formatCondition);
            if (matcher.matches()) {
                this.checkMS = matcher.group("varName");
                if (this.checkMS != null) {
                    return;
                }
            }
            try {
                this.condition = new OR(formatCondition);
            }
            catch (Exception e) {
                API.LOGGER.debug(e.toString());
            }
        }

        public boolean check(HashMap<String, TickMS> vars) {
            if (this.isDefault) {
                return true;
            }
            if (this.checkMS != null) {
                return TimingStorage.renderLastTimingMS && vars.containsKey(this.checkMS) && vars.get((Object)this.checkMS).ms != null;
            }
            if (this.condition == null) {
                return false;
            }
            return this.condition.check(vars);
        }

        private static class ADD {
            String[] parts;

            ADD(String add) {
                this.parts = add.split("\\+");
            }

            public Integer get(HashMap<String, TickMS> vars) {
                int result = 0;
                for (String part : this.parts) {
                    Integer v = vars.containsKey(part) ? Integer.valueOf(vars.get((Object)part).tickCount) : MathUtil.parseInt(part, null);
                    if (v == null) {
                        return null;
                    }
                    result += v.intValue();
                }
                return result;
            }
        }

        private static class COND {
            ADD[] parts;
            Operator operator = null;

            COND(String cond) {
                for (Operator op : Operator.values()) {
                    if (op == Operator.NONE || !cond.contains(op.operator)) continue;
                    if (this.operator != null) {
                        throw new IllegalArgumentException(String.format("Multiple operators of different types found in '%s' when only one type was expected", cond));
                    }
                    this.operator = op;
                }
                if (this.operator == null) {
                    throw new IllegalArgumentException(String.format("No operator found found in '%s' when only at least one was expected", cond));
                }
                String[] parts = cond.split(this.operator.operator);
                this.parts = new ADD[parts.length];
                for (int i = 0; i < parts.length; ++i) {
                    this.parts[i] = new ADD(parts[i]);
                }
            }

            private boolean helperCheck(List<Integer> parts) {
                if (parts.size() == 2) {
                    return this.operator.check.check(parts.get(0), parts.get(1));
                }
                return this.operator.check.check(parts.get(0), parts.get(1)) && this.helperCheck(parts.subList(1, parts.size()));
            }

            boolean check(HashMap<String, TickMS> vars) {
                ArrayList<Integer> parts = new ArrayList<Integer>();
                for (ADD part : this.parts) {
                    Integer v = part.get(vars);
                    if (v == null) {
                        return false;
                    }
                    parts.add(v);
                }
                return this.helperCheck(parts);
            }
        }

        private static class AND {
            COND[] parts;

            AND(String andCond) {
                String[] parts = andCond.split("&&");
                this.parts = new COND[parts.length];
                for (int i = 0; i < parts.length; ++i) {
                    this.parts[i] = new COND(parts[i]);
                }
            }

            boolean check(HashMap<String, TickMS> vars) {
                for (COND p : this.parts) {
                    if (p.check(vars)) continue;
                    return false;
                }
                return true;
            }
        }

        private static class OR {
            AND[] parts;

            OR(String orCond) {
                String[] parts = orCond.split("\\|\\|");
                this.parts = new AND[parts.length];
                for (int i = 0; i < parts.length; ++i) {
                    this.parts[i] = new AND(parts[i]);
                }
            }

            boolean check(HashMap<String, TickMS> vars) {
                for (AND p : this.parts) {
                    if (!p.check(vars)) continue;
                    return true;
                }
                return false;
            }
        }

        public static enum Operator {
            EQUALS("==", (a, b) -> a == b),
            NOT_EQUALS("!=", (a, b) -> a != b),
            GREATER_EQUALS(">=", (a, b) -> a >= b),
            GREATER(">", (a, b) -> a > b),
            SMALLER_EQUALS("<=", (a, b) -> a <= b),
            SMALLER("<", (a, b) -> a < b),
            NONE(null, (a, b) -> false);

            public final String operator;
            public final CheckLambda check;

            private Operator(String operator, CheckLambda check) {
                this.operator = operator;
                this.check = check;
            }

            @FunctionalInterface
            private static interface CheckLambda {
                public boolean check(int var1, int var2);
            }
        }
    }

    public static class FormatString {
        private static final String rawRegex = "(?<varName>[a-zA-Z]+)(?<ms>_ms)?";
        public static final Pattern regexPatternRaw = Pattern.compile("(?<varName>[a-zA-Z]+)(?<ms>_ms)?");
        private static final String regex = "\\{(?<varName>[a-zA-Z]+)(?<ms>_ms)?}";
        public static final Pattern regexPattern = Pattern.compile("\\{(?<varName>[a-zA-Z]+)(?<ms>_ms)?}");
        String formatString;
        List<Tuple<String, Boolean>> vars = new ArrayList<Tuple<String, Boolean>>();

        @JsonCreator
        public FormatString(String formatString) {
            this.formatString = formatString;
            Matcher matcher = regexPattern.matcher(formatString);
            while (matcher.find()) {
                this.vars.add(new Tuple<String, Boolean>(matcher.group("varName"), matcher.group("varName") != null));
            }
        }

        public String get(HashMap<String, TickMS> vars) {
            String returnString = this.formatString;
            for (Tuple<String, Boolean> var : this.vars) {
                if (vars.containsKey(var.getFirst())) {
                    if (var.getSecond().booleanValue()) {
                        returnString = returnString.replaceAll("\\{" + var.getFirst() + "_ms}", vars.get(var.getFirst()).getMSOrEmpty());
                    }
                    returnString = returnString.replaceAll("\\{" + var.getFirst() + "}", String.valueOf(vars.get((Object)var.getFirst()).tickCount));
                    continue;
                }
                return "";
            }
            return returnString;
        }
    }
}

