/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.ticks;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.github.kurrycat.mpkmod.ticks.ButtonMS;
import io.github.kurrycat.mpkmod.ticks.Timing;
import io.github.kurrycat.mpkmod.ticks.TimingInput;
import io.github.kurrycat.mpkmod.util.MathUtil;
import io.github.kurrycat.mpkmod.util.Range;
import io.github.kurrycat.mpkmod.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimingEntry {
    private static final String tickCountRegex = "^((((?<diffNumber>\\d+)-)?((?<varName>[a-zA-Z]+)(\\{(?<lowerRange>\\d+)?,(?<upperRange>\\d+)?})?))|(?<rawCount>\\d+))$";
    private static final Pattern tickCountPattern = Pattern.compile("^((((?<diffNumber>\\d+)-)?((?<varName>[a-zA-Z]+)(\\{(?<lowerRange>\\d+)?,(?<upperRange>\\d+)?})?))|(?<rawCount>\\d+))$");
    private static final String tickInputRegex = "^W?A?S?D?P?N?J?(!?G)?$";
    private static final Pattern tickInputPattern = Pattern.compile("^W?A?S?D?P?N?J?(!?G)?$");
    public String timingEntry;
    public TimingInput timingInput;
    private Integer number;
    private String varName;
    private Range range;

    @JsonCreator
    public TimingEntry(String timingEntry) {
        this.timingEntry = timingEntry;
        String[] split = timingEntry.split(":", -1);
        if (split.length == 1) {
            this.number = 1;
            this.varName = null;
            this.range = null;
            this.timingInput = new TimingInput(split[0]);
        } else if (split.length == 2) {
            Matcher matcher = tickCountPattern.matcher(split[0]);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("Invalid tick count: %s", split[0]));
            }
            Integer diffNumber = MathUtil.parseInt(matcher.group("diffNumber"), null);
            String varName = matcher.group("varName");
            Integer lower = MathUtil.parseInt(matcher.group("lowerRange"), null);
            Integer upper = MathUtil.parseInt(matcher.group("upperRange"), null);
            Integer rawCount = MathUtil.parseInt(matcher.group("rawCount"), null);
            this.number = diffNumber == null ? rawCount : diffNumber;
            this.varName = varName;
            this.range = new Range(lower, upper);
            this.timingInput = new TimingInput(split[1]);
        } else {
            throw new IllegalArgumentException(String.format("More than one : found in timingEntry '%s', expected one", timingEntry));
        }
    }

    public boolean varNameMatches(TimingEntry other) {
        return this.varName != null && other.varName != null && this.varName.equals(other.varName);
    }

    public Integer matches(List<TimingInput> inputList, int startIndex, HashMap<String, Timing.TickMS> vars, boolean repeatedVar) {
        if (this.number == null && this.varName == null) {
            return null;
        }
        if (this.number == null) {
            int i;
            for (i = startIndex; i < inputList.size() && inputList.get(i).equals(this.timingInput); ++i) {
            }
            if (this.range.includes(i -= startIndex) || this.range.isAbove(i)) {
                if (vars.containsKey(this.varName) && repeatedVar) {
                    vars.get((Object)this.varName).tickCount += this.range.constrain(i);
                } else {
                    vars.put(this.varName, new Timing.TickMS(this.range.constrain(i)));
                }
                vars.get((Object)this.varName).ms = this.getMS(startIndex + i - vars.get((Object)this.varName).tickCount, vars.get((Object)this.varName).tickCount, inputList);
                return this.range.constrain(i);
            }
            return null;
        }
        int countToMatch = this.number;
        if (this.varName != null) {
            if (!vars.containsKey(this.varName)) {
                throw new IllegalArgumentException(String.format("The variable %s has not been defined in a prior timing input (at %s)", this.varName, this.timingEntry));
            }
            countToMatch -= vars.get((Object)this.varName).tickCount;
        }
        if (inputList.size() == startIndex && this.number != 0) {
            return null;
        }
        int i = startIndex;
        while (countToMatch > 0) {
            if (i >= inputList.size()) {
                return null;
            }
            if (!inputList.get(i).equals(this.timingInput)) {
                return null;
            }
            --countToMatch;
            ++i;
        }
        return i - startIndex;
    }

    private Integer getMS(int startIndex, int matchCount, List<TimingInput> inputList) {
        if (matchCount == 0 || startIndex + matchCount >= inputList.size()) {
            return null;
        }
        TimingInput before = startIndex == 0 ? TimingInput.stopTick() : inputList.get(startIndex - 1);
        TimingInput after = inputList.get(startIndex + matchCount);
        ArrayList<TimingInput> curr = new ArrayList<TimingInput>();
        for (int i = startIndex; i < startIndex + matchCount; ++i) {
            if (!curr.isEmpty() && curr.get(curr.size() - 1).equals(inputList.get(i))) continue;
            curr.add(inputList.get(i));
        }
        Tuple<ButtonMS.Button, ButtonMS.Button> range = TimingInput.findMSButtons(before, after, curr);
        if (range == null) {
            return null;
        }
        ButtonMS startMS = curr.get((int)0).msList.forKey(range.getFirst());
        if (startMS == null) {
            return null;
        }
        ButtonMS endMS = after.msList.forKey(range.getSecond());
        if (endMS == null) {
            return null;
        }
        return endMS.msFrom(startMS);
    }
}

