/*
 * Decompiled with CFR 0.152.
 */
package io.github.kurrycat.mpkmod.util;

import io.github.kurrycat.mpkmod.gui.infovars.InfoString;
import io.github.kurrycat.mpkmod.util.FormatDecimals;
import io.github.kurrycat.mpkmod.util.Vector3D;

@InfoString.DataClass
public class BoundingBox3D
implements FormatDecimals {
    public static final BoundingBox3D ZERO = new BoundingBox3D(Vector3D.ZERO, Vector3D.ZERO);
    private Vector3D min;
    private Vector3D max;

    public BoundingBox3D(Vector3D corner1, Vector3D corner2) {
        this.min = new Vector3D(Math.min(corner1.getX(), corner2.getX()), Math.min(corner1.getY(), corner2.getY()), Math.min(corner1.getZ(), corner2.getZ()));
        this.max = new Vector3D(Math.max(corner1.getX(), corner2.getX()), Math.max(corner1.getY(), corner2.getY()), Math.max(corner1.getZ(), corner2.getZ()));
    }

    public static BoundingBox3D asBlockPos(Vector3D pos) {
        return new BoundingBox3D(pos.floor(), pos.floor().add(1.0));
    }

    @InfoString.Getter
    public Vector3D getSize() {
        return this.max.sub(this.min);
    }

    public BoundingBox3D setMinX(double minX) {
        this.min.setX(minX);
        return this;
    }

    public BoundingBox3D setMinY(double minY) {
        this.min.setY(minY);
        return this;
    }

    public BoundingBox3D setMinZ(double minZ) {
        this.min.setZ(minZ);
        return this;
    }

    public BoundingBox3D setMaxX(double maxX) {
        this.max.setX(maxX);
        return this;
    }

    public BoundingBox3D setMaxY(double maxY) {
        this.max.setY(maxY);
        return this;
    }

    public BoundingBox3D setMaxZ(double maxZ) {
        this.max.setZ(maxZ);
        return this;
    }

    public boolean intersectsOrTouchesXZ(BoundingBox3D other) {
        return other.maxX() >= this.minX() && other.minX() <= this.maxX() && other.maxZ() >= this.minZ() && other.minZ() <= this.maxZ();
    }

    public double maxX() {
        return this.max.getX();
    }

    public double minX() {
        return this.min.getX();
    }

    public double maxZ() {
        return this.max.getZ();
    }

    public double minZ() {
        return this.min.getZ();
    }

    public Vector3D distanceTo(BoundingBox3D other) {
        return new Vector3D(this.midX() > other.midX() ? this.minX() - other.maxX() : other.minX() - this.maxX(), this.midY() > other.midY() ? this.minY() - other.maxY() : other.minY() - this.maxY(), this.midZ() > other.midZ() ? this.minZ() - other.maxZ() : other.minZ() - this.maxZ());
    }

    public double midX() {
        return (this.minX() + this.maxX()) / 2.0;
    }

    public double midY() {
        return (this.minY() + this.maxY()) / 2.0;
    }

    public double minY() {
        return this.min.getY();
    }

    public double maxY() {
        return this.max.getY();
    }

    public double midZ() {
        return (this.minZ() + this.maxZ()) / 2.0;
    }

    public BoundingBox3D expand(double amount) {
        return new BoundingBox3D(this.min.sub(amount), this.max.add(amount));
    }

    public int hashCode() {
        return this.min.hashCode() + this.max.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof BoundingBox3D && this.min.equals(((BoundingBox3D)obj).min) && this.max.equals(((BoundingBox3D)obj).max);
    }

    public String toString() {
        return "BoundingBox3D{" + this.min + " - " + this.max + "}";
    }

    public BoundingBox3D move(Vector3D v) {
        return this.move(v.getX(), v.getY(), v.getZ());
    }

    public BoundingBox3D move(double x, double y, double z) {
        return new BoundingBox3D(this.getMin().add(x, y, z), this.getMax().add(x, y, z));
    }

    @InfoString.Getter
    public Vector3D getMin() {
        return this.min;
    }

    @InfoString.Getter
    public Vector3D getMax() {
        return this.max;
    }

    @Override
    public String formatDecimals(int decimals, boolean keepZeros) {
        return "[" + this.min.formatDecimals(decimals, keepZeros) + " - " + this.max.formatDecimals(decimals, keepZeros) + "]";
    }
}

