/*
 * Decompiled with CFR 0.152.
 */
package org.primal;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import org.jetbrains.annotations.NotNull;
import org.primal.Primal_Registries;
import org.primal.entity.animal.BearEntity;
import org.primal.entity.animal.CrocodileEntity;
import org.primal.entity.animal.EagleEntity;
import org.primal.entity.animal.SharkEntity;
import org.primal.registry.Primal_Activities;
import org.primal.registry.Primal_Advancements;
import org.primal.registry.Primal_BlockEntities;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Effects;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_Items;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Potions;
import org.primal.registry.Primal_Sensors;
import org.primal.registry.Primal_Sounds;
import org.primal.registry.Primal_VillagerCustomTrades;
import org.primal.registry.Primal_WorldGen;
import org.primal.util.MiscUtil;

@EventBusSubscriber(modid="primal", bus=EventBusSubscriber.Bus.MOD)
@Mod(value="primal")
public class Primal_Main {
    public static final String MOD_ID = "primal";

    public Primal_Main(IEventBus modEventBus) {
        Primal_Sensors.init();
        Primal_Registries.SENSOR_TYPES.register(modEventBus);
        Primal_MemoryModuleTypes.init();
        Primal_Registries.MEMORY_MODULE_TYPES.register(modEventBus);
        Primal_Activities.init();
        Primal_Registries.ACTIVITIES.register(modEventBus);
        Primal_Effects.init();
        Primal_Registries.MOB_EFFECTS.register(modEventBus);
        Primal_Potions.init();
        Primal_Registries.POTIONS.register(modEventBus);
        Primal_Entities.init();
        Primal_Registries.ENTITIES.register(modEventBus);
        Primal_Sounds.init();
        Primal_Registries.SOUNDS.register(modEventBus);
        Primal_Blocks.init();
        Primal_Registries.BLOCKS.register(modEventBus);
        Primal_BlockEntities.init();
        Primal_Registries.BLOCK_ENTITIES.register(modEventBus);
        Primal_Items.initItems();
        Primal_Registries.ITEMS.register(modEventBus);
        Primal_Items.initGroups();
        Primal_Registries.CREATIVE_MODE_TABS.register(modEventBus);
        Primal_Advancements.initCriteria();
        Primal_Registries.CRITERIA.register(modEventBus);
        Primal_Advancements.initEntitySubPredicates();
        Primal_Registries.ENTITY_SUB_PREDICATE_TYPES.register(modEventBus);
        Primal_WorldGen.init();
        Primal_Registries.FEATURES.register(modEventBus);
        Primal_VillagerCustomTrades.init();
    }

    @SubscribeEvent
    public static void registerCommonEvent(FMLCommonSetupEvent event) {
        Primal_Main.setFlammables();
    }

    public static void setFlammables() {
        FireBlock fireblock = (FireBlock)Blocks.FIRE;
        fireblock.setFlammable((Block)Primal_Blocks.SHORT_RIVER_REEDS.get(), 30, 60);
        fireblock.setFlammable((Block)Primal_Blocks.RIVER_REEDS.get(), 30, 60);
        fireblock.setFlammable((Block)Primal_Blocks.NEST_BLOCK.get(), 30, 60);
        fireblock.setFlammable((Block)Primal_Blocks.STRAW_BALE.get(), 100, 200);
    }

    @SubscribeEvent
    public static void addToCreativeTabs(@NotNull BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(CreativeModeTabs.FOOD_AND_DRINKS)) {
            MiscUtil.insertItemsAfter(event, Items.ENCHANTED_GOLDEN_APPLE.getDefaultInstance(), ((Item)Primal_Items.APPLE_FRITTER.get()).getDefaultInstance(), ((Item)Primal_Items.GOLDEN_APPLE_FRITTER.get()).getDefaultInstance(), ((Item)Primal_Items.ENCHANTED_GOLDEN_APPLE_FRITTER.get()).getDefaultInstance());
        }
        if (event.getTabKey().equals(CreativeModeTabs.NATURAL_BLOCKS)) {
            MiscUtil.insertItemsAfter(event, Items.SHORT_GRASS.getDefaultInstance(), ((Item)Primal_Items.SHORT_RIVER_REEDS.get()).getDefaultInstance());
            MiscUtil.insertItemsAfter(event, Items.TALL_GRASS.getDefaultInstance(), ((Item)Primal_Items.RIVER_REEDS.get()).getDefaultInstance());
            MiscUtil.insertItemsAfter(event, Items.FROGSPAWN.getDefaultInstance(), ((Item)Primal_Items.NEST.get()).getDefaultInstance());
            MiscUtil.insertItemsAfter(event, Items.TURTLE_EGG.getDefaultInstance(), ((Item)Primal_Items.CROCODILE_EGG.get()).getDefaultInstance(), ((Item)Primal_Items.EAGLE_EGG.get()).getDefaultInstance());
            MiscUtil.insertItemsAfter(event, Items.LILY_PAD.getDefaultInstance(), ((Item)Primal_Items.SEASHELLS.get()).getDefaultInstance());
            MiscUtil.insertItemsAfter(event, Items.HAY_BLOCK.getDefaultInstance(), ((Item)Primal_Items.STRAW_BLOCK.get()).getDefaultInstance());
        }
        if (event.getTabKey().equals(CreativeModeTabs.INGREDIENTS)) {
            MiscUtil.insertItemsAfter(event, Items.TURTLE_SCUTE.getDefaultInstance(), ((Item)Primal_Items.CROCODILE_SCUTE.get()).getDefaultInstance());
            MiscUtil.insertItemsAfter(event, Items.PRISMARINE_CRYSTALS.getDefaultInstance(), ((Item)Primal_Items.SHARK_TOOTH.get()).getDefaultInstance());
            MiscUtil.insertItemsAfter(event, Items.FLOWER_BANNER_PATTERN.getDefaultInstance(), ((Item)Primal_Items.PAW_BANNER_PATTERN.get()).getDefaultInstance(), ((Item)Primal_Items.JAWS_BANNER_PATTERN.get()).getDefaultInstance(), ((Item)Primal_Items.MARSH_BANNER_PATTERN.get()).getDefaultInstance(), ((Item)Primal_Items.EYRIE_BANNER_PATTERN.get()).getDefaultInstance());
        }
        if (event.getTabKey().equals(CreativeModeTabs.BUILDING_BLOCKS)) {
            MiscUtil.insertItemsAfter(event, Items.DARK_PRISMARINE_SLAB.getDefaultInstance(), ((Item)Primal_Items.CROCODILE_SCUTE_BLOCK.get()).getDefaultInstance(), ((Item)Primal_Items.CROCODILE_SCUTE_STAIRS.get()).getDefaultInstance(), ((Item)Primal_Items.CROCODILE_SCUTE_SLAB.get()).getDefaultInstance(), ((Item)Primal_Items.CHISELED_CROCODILE_SCUTE.get()).getDefaultInstance(), ((Item)Primal_Items.CROCODILE_SCUTE_SHINGLE.get()).getDefaultInstance());
        }
        if (event.getTabKey().equals(CreativeModeTabs.SPAWN_EGGS)) {
            event.insertAfter(Items.BAT_SPAWN_EGG.getDefaultInstance(), ((Item)Primal_Items.BEAR_SPAWN_EGG.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.CREEPER_SPAWN_EGG.getDefaultInstance(), ((Item)Primal_Items.CROCODILE_SPAWN_EGG.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.DROWNED_SPAWN_EGG.getDefaultInstance(), ((Item)Primal_Items.EAGLE_SPAWN_EGG.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.SALMON_SPAWN_EGG.getDefaultInstance(), ((Item)Primal_Items.SHARK_SPAWN_EGG.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    @SubscribeEvent
    public static void registerAttribute(@NotNull EntityAttributeCreationEvent event) {
        event.put((EntityType)Primal_Entities.BEAR.get(), BearEntity.createAttributes().build());
        event.put((EntityType)Primal_Entities.SHARK.get(), SharkEntity.createAttributes().build());
        event.put((EntityType)Primal_Entities.CROCODILE.get(), CrocodileEntity.createAttributes().build());
        event.put((EntityType)Primal_Entities.EAGLE.get(), EagleEntity.createAttributes().build());
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(@NotNull RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)Primal_Entities.BEAR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)Primal_Entities.SHARK.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::checkSurfaceWaterAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)Primal_Entities.CROCODILE.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CrocodileEntity::checkCrocodileSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)Primal_Entities.EAGLE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    @EventBusSubscriber(modid="primal", bus=EventBusSubscriber.Bus.GAME)
    private static class Primal_MainGameBus {
        private Primal_MainGameBus() {
        }

        @SubscribeEvent
        public static void captureDropsForCrocodile(@NotNull LivingDropsEvent event) {
            Entity entity;
            if (event.getSource().getEntity() != null && (entity = event.getSource().getEntity()) instanceof CrocodileEntity) {
                CrocodileEntity crocodile = (CrocodileEntity)entity;
                if (!(event.getEntity() instanceof Player)) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    ArrayList<ItemEntity> stacksEaten = new ArrayList<ItemEntity>();
                    for (ItemEntity itemEntity : event.getDrops()) {
                        if (!crocodile.canEatItem(itemEntity.getItem())) continue;
                        stacks.add(itemEntity.getItem());
                        stacksEaten.add(itemEntity);
                    }
                    for (ItemEntity itemEntity : stacksEaten) {
                        event.getDrops().remove(itemEntity);
                    }
                    crocodile.addItemsToInventory(stacks);
                }
            }
        }

        @SubscribeEvent
        public static void customizeOverlay(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RenderGuiLayerEvent.Pre event) {
            if (VanillaGuiLayers.VEHICLE_HEALTH == event.getName()) {
                assert (Minecraft.getInstance().player != null);
                if (MiscUtil.isRidingUnfriendly((LivingEntity)Minecraft.getInstance().player)) {
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void registerBrewingRecipes(RegisterBrewingRecipesEvent event) {
            PotionBrewing.Builder builder = event.getBuilder();
            builder.addMix(Potions.AWKWARD, (Item)Primal_Items.SHARK_TOOTH.get(), Primal_Potions.HEAVINESS);
        }

        @SubscribeEvent
        public static void modifyLootTables(LootTableLoadEvent event) {
            LootTable originalTable;
            LootPool originalPool;
            if (event.getName().equals((Object)BuiltInLootTables.SPAWNER_TRIAL_ITEMS_TO_DROP_WHEN_OMINOUS.location()) && (originalPool = (originalTable = event.getTable()).getPool("pool0")) != null) {
                LootPoolEntryContainer heaviness_potion = LootItem.lootTableItem((ItemLike)Items.LINGERING_POTION).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).apply((LootItemFunction.Builder)SetPotionFunction.setPotion(Primal_Potions.HEAVINESS)).build();
                MiscUtil.extendLootPool(originalPool, List.of(heaviness_potion));
            }
            if (event.getName().equals((Object)BuiltInLootTables.UNDERWATER_RUIN_SMALL.location()) && (originalPool = (originalTable = event.getTable()).getPool("pool1")) != null) {
                LootPoolEntryContainer shark_tooth = LootItem.lootTableItem((ItemLike)((ItemLike)Primal_Items.SHARK_TOOTH.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).setWeight(2).build();
                MiscUtil.extendLootPool(originalPool, List.of(shark_tooth));
            }
        }
    }
}

