/*
 * Decompiled with CFR 0.152.
 */
package org.primal.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.NotNull;
import org.primal.registry.Primal_Advancements;

public class SharkKillsEntity
extends SimpleCriterionTrigger<Conditions> {
    @NotNull
    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public void trigger(ServerPlayer player, LivingEntity entity) {
        LootContext lootContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)entity);
        this.trigger(player, conditions -> conditions.entity.map(lootContextPredicate -> lootContextPredicate.matches(lootContext)).orElse(false));
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> entity) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("entity").forGetter(Conditions::entity)).apply((Applicative)instance, Conditions::new));

        public static Criterion<Conditions> create(EntityPredicate.Builder entity) {
            return ((SharkKillsEntity)((Object)Primal_Advancements.FEED_SHARK.get())).createCriterion((CriterionTriggerInstance)new Conditions(Optional.empty(), Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)entity))));
        }
    }
}

