/*
 * Decompiled with CFR 0.152.
 */
package org.primal.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SeashellsBlock
extends Block {
    public static final MapCodec<SeashellsBlock> CODEC = SeashellsBlock.simpleCodec(SeashellsBlock::new);
    public static final IntegerProperty AMOUNT = IntegerProperty.create((String)"seashells_amount", (int)1, (int)4);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final BiFunction<Direction, Integer, VoxelShape> SHAPE_BY_PROPERTIES = Util.memoize((direction, integer) -> {
        VoxelShape[] avoxelshape = new VoxelShape[]{Block.box((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)7.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)9.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)9.0, (double)1.0, (double)9.0), Block.box((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)1.0, (double)16.0)};
        VoxelShape voxelshape = Shapes.empty();
        for (int i = 0; i < integer; ++i) {
            int j = Math.floorMod(i - direction.get2DDataValue(), 4);
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)avoxelshape[j]);
        }
        return voxelshape.singleEncompassing();
    });

    public SeashellsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AMOUNT, (Comparable)Integer.valueOf(1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, AMOUNT, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level levelaccessor = context.getLevel();
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        BlockPos blockpos = context.getClickedPos();
        return blockstate.is((Block)this) ? (BlockState)blockstate.setValue((Property)AMOUNT, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.getValue((Property)AMOUNT) + 1))) : (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.getFluidState(blockpos).getType() == Fluids.WATER));
    }

    @NotNull
    protected BlockState updateShape(BlockState state, @NotNull Direction directionUpdated, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (directionUpdated == Direction.DOWN && !this.canSurvive(state, (LevelReader)level, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, BlockPos pos) {
        return SeashellsBlock.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.below());
    }

    @NotNull
    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public boolean canBeReplaced(@NotNull BlockState state, BlockPlaceContext context) {
        return !context.isSecondaryUseActive() && context.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)AMOUNT) < 4 || super.canBeReplaced(state, context);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext context) {
        return SHAPE_BY_PROPERTIES.apply((Direction)state.getValue((Property)FACING), (Integer)state.getValue((Property)AMOUNT));
    }

    @NotNull
    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }
}

