/*
 * Decompiled with CFR 0.152.
 */
package org.primal.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.primal.block.properties.SharkToothThickness;
import org.primal.registry.Primal_DamageTypes;

public class SharkToothBlock
extends Block {
    public static final MapCodec<SharkToothBlock> CODEC = SharkToothBlock.simpleCodec(SharkToothBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final EnumProperty<SharkToothThickness> THICKNESS = EnumProperty.create((String)"thickness", SharkToothThickness.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final Map<Direction, VoxelShape> tipShapesByDirection = Map.of(Direction.UP, Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Direction.DOWN, Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Direction.NORTH, Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)16.0), Direction.SOUTH, Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)11.0), Direction.EAST, Block.box((double)0.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Direction.WEST, Block.box((double)5.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0));
    private final Map<Direction, VoxelShape> baseShapesByDirection = Map.of(Direction.UP, Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Direction.DOWN, Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Direction.NORTH, Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)16.0), Direction.SOUTH, Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)16.0), Direction.EAST, Block.box((double)0.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Direction.WEST, Block.box((double)0.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0));

    public SharkToothBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue(THICKNESS, (Comparable)((Object)SharkToothThickness.TIP))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, THICKNESS, WATERLOGGED});
    }

    protected boolean canSurvive(BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        return this.isValidPointedDripstonePlacement(level, pos, (Direction)state.getValue((Property)FACING));
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState updateShape(BlockState state, @NotNull Direction directionUpdated, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (this.updateOpposites(state, directionUpdated) && !facingState.is((Block)this) && !this.canSurvive(state, (LevelReader)level, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (this.isValueForConnection(state, Direction.UP, directionUpdated, facingState) || this.isValueForConnection(state, Direction.DOWN, directionUpdated, facingState) || this.isValueForConnection(state, Direction.NORTH, directionUpdated, facingState) || this.isValueForConnection(state, Direction.SOUTH, directionUpdated, facingState) || this.isValueForConnection(state, Direction.EAST, directionUpdated, facingState) || this.isValueForConnection(state, Direction.WEST, directionUpdated, facingState)) {
            return (BlockState)state.setValue(THICKNESS, (Comparable)((Object)SharkToothThickness.BASE));
        }
        if (state.getValue(THICKNESS) == SharkToothThickness.BASE && !facingState.is((Block)this) && directionUpdated == state.getValue((Property)FACING)) {
            return (BlockState)state.setValue(THICKNESS, (Comparable)((Object)SharkToothThickness.TIP));
        }
        return state;
    }

    private boolean isValueForConnection(BlockState state, Direction directionToCheck, Direction directionUpdated, BlockState facingState) {
        return state.getValue(THICKNESS) == SharkToothThickness.TIP && state.getValue((Property)FACING) == directionToCheck && directionUpdated == directionToCheck && facingState.is((Block)this) && facingState.getValue((Property)FACING) == directionToCheck;
    }

    private boolean updateOpposite(BlockState state, Direction directionToCheck, Direction directionUpdated) {
        return state.getValue((Property)FACING) == directionToCheck && directionUpdated == directionToCheck.getOpposite();
    }

    private boolean updateOpposites(BlockState state, Direction directionUpdated) {
        return this.updateOpposite(state, Direction.UP, directionUpdated) || this.updateOpposite(state, Direction.DOWN, directionUpdated) || this.updateOpposite(state, Direction.NORTH, directionUpdated) || this.updateOpposite(state, Direction.SOUTH, directionUpdated) || this.updateOpposite(state, Direction.EAST, directionUpdated) || this.updateOpposite(state, Direction.WEST, directionUpdated);
    }

    private boolean isValidPointedDripstonePlacement(LevelReader level, BlockPos pos, Direction dir) {
        BlockPos blockpos = pos.relative(dir.getOpposite());
        BlockState blockstate = level.getBlockState(blockpos);
        return (blockstate.is(Blocks.MOVING_PISTON) || blockstate.isFaceSturdy((BlockGetter)level, blockpos, dir, SupportType.CENTER) || blockstate.is((Block)this) && blockstate.getValue((Property)FACING) == dir) && !blockstate.isAir();
    }

    private boolean isToothWithDirection(BlockState state, Direction dir) {
        return state.is((Block)this) && state.getValue((Property)FACING) == dir;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos;
        Level levelaccessor = context.getLevel();
        SharkToothThickness sharkToothThickness = this.calculateToothThickness((LevelReader)levelaccessor, blockpos = context.getClickedPos(), context.getClickedFace().getOpposite());
        return sharkToothThickness == null ? null : (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace())).setValue(THICKNESS, (Comparable)((Object)sharkToothThickness))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.getFluidState(blockpos).getType() == Fluids.WATER));
    }

    private SharkToothThickness calculateToothThickness(LevelReader level, BlockPos pos, Direction dir) {
        BlockState onBlockPlacedState = level.getBlockState(pos.relative(dir));
        if (this.isToothWithDirection(onBlockPlacedState, dir)) {
            return SharkToothThickness.BASE;
        }
        return SharkToothThickness.TIP;
    }

    @NotNull
    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    protected VoxelShape getOcclusionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return Shapes.empty();
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return state.getValue(THICKNESS) == SharkToothThickness.TIP ? this.tipShapesByDirection.get(state.getValue((Property)FACING)) : this.baseShapesByDirection.get(state.getValue((Property)FACING));
    }

    protected boolean isCollisionShapeFullBlock(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return false;
    }

    public void fallOn(@NotNull Level level, BlockState state, @NotNull BlockPos pos, @NotNull Entity entity, float fallDistance) {
        if (state.getValue((Property)FACING) == Direction.UP && state.getValue(THICKNESS) == SharkToothThickness.TIP) {
            entity.causeFallDamage(fallDistance + 4.0f, 2.0f, Primal_DamageTypes.sharkTooth(level));
        } else {
            super.fallOn(level, state, pos, entity, fallDistance);
        }
    }

    public boolean collisionExtendsVertically(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Entity collidingEntity) {
        return super.collisionExtendsVertically(state, level, pos, collidingEntity);
    }

    protected void entityInside(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (level.isClientSide) {
            return;
        }
        AABB blockBox = new AABB(pos);
        AABB entityBox = entity.getBoundingBox();
        if (!blockBox.intersects(entityBox)) {
            return;
        }
        Direction face = SharkToothBlock.getDirection(entityBox, blockBox);
        if (face != null) {
            if (entity.isShiftKeyDown() && face == Direction.UP) {
                return;
            }
            if (state.getValue((Property)FACING) == face) {
                entity.hurt(Primal_DamageTypes.sharkTooth(level), 2.0f);
            }
        }
    }

    @Nullable
    private static Direction getDirection(AABB eBox, AABB blockBox) {
        double dxWest = eBox.maxX - blockBox.minX;
        double dxEast = blockBox.maxX - eBox.minX;
        double dzNorth = eBox.maxZ - blockBox.minZ;
        double dzSouth = blockBox.maxZ - eBox.minZ;
        double dyDown = eBox.maxY - blockBox.minY;
        double dyUp = blockBox.maxY - eBox.minY;
        double min = Double.MAX_VALUE;
        Direction face = null;
        if (dxWest >= 0.0 && dxWest < min) {
            min = dxWest;
            face = Direction.WEST;
        }
        if (dxEast >= 0.0 && dxEast < min) {
            min = dxEast;
            face = Direction.EAST;
        }
        if (dzNorth >= 0.0 && dzNorth < min) {
            min = dzNorth;
            face = Direction.NORTH;
        }
        if (dzSouth >= 0.0 && dzSouth < min) {
            min = dzSouth;
            face = Direction.SOUTH;
        }
        if (dyDown >= 0.0 && dyDown < min) {
            min = dyDown;
            face = Direction.DOWN;
        }
        if (dyUp >= 0.0 && dyUp < min) {
            min = dyUp;
            face = Direction.UP;
        }
        return face;
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType pathComputationType) {
        return false;
    }

    @NotNull
    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }
}

