/*
 * Decompiled with CFR 0.152.
 */
package org.primal.block_entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.primal.util.AnimalEgg;

public class NestBlockEntity
extends BlockEntity {
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);

    public NestBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(@NotNull Connection net, ClientboundBlockEntityDataPacket pkt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        this.loadAdditional(pkt.getTag(), lookup);
    }

    public void updateBlock() {
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void removeEgg(@Nullable LivingEntity target) {
        BlockItem blockItem;
        Item item = this.getEgg().getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof AnimalEgg) {
            AnimalEgg animalEgg = (AnimalEgg)item;
            if (target != null && this.getLevel() != null) {
                List<Entity> allEntitiesList = this.getLevel().getEntitiesOfClass(Entity.class, new AABB(this.getBlockPos()).inflate(10.0)).stream().filter(entity -> entity.getType() == animalEgg.getAnimal().get()).toList();
                for (Entity entityNearby : allEntitiesList) {
                    LivingEntity animal;
                    if (!(entityNearby instanceof LivingEntity) || (animal = (LivingEntity)entityNearby).isBaby()) continue;
                    Brain brain = animal.getBrain();
                    brain.eraseMemory(MemoryModuleType.PACIFIED);
                    brain.eraseMemory(MemoryModuleType.BREED_TARGET);
                    brain.setMemory(MemoryModuleType.ATTACK_TARGET, (Object)target);
                }
            }
        }
        this.setItem(this.getEgg().getCount() - 1 <= 0 ? ItemStack.EMPTY : new ItemStack((ItemLike)this.getEgg().getItem(), this.getEgg().getCount() - 1));
        this.updateBlock();
    }

    public void addEgg(ItemStack stack, @Nullable LivingEntity player) {
        this.setItem(new ItemStack((ItemLike)stack.getItem(), this.getEgg().getCount() + 1));
        this.updateBlock();
    }

    public void setEgg(ItemStack stack, @Nullable LivingEntity player) {
        this.setItem(stack);
        this.updateBlock();
    }

    public ItemStack getEgg() {
        return (ItemStack)this.items.getFirst();
    }

    public int getEggsAmount() {
        return ((ItemStack)this.items.getFirst()).getCount();
    }

    public void setItem(ItemStack stack) {
        this.items.set(0, (Object)stack);
    }
}

