/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.bear;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.BearEntity;

public class BearBeg
extends Behavior<BearEntity> {
    private Player player;

    public BearBeg() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ROAR_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), Integer.MAX_VALUE);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, @NotNull BearEntity bear) {
        this.player = level.getNearestPlayer(TargetingConditions.forNonCombat().range(3.5), (LivingEntity)bear);
        return this.player != null && !bear.bearCollapses() && !bear.isBearSleeping() && (BearEntity.isTameFood(this.player.getMainHandItem()) && !bear.isTame() || BearEntity.isHealFood(this.player.getMainHandItem()) && bear.getHealth() < bear.getMaxHealth() && bear.isTame() || BearEntity.isMatingFood(this.player.getMainHandItem()) && !bear.isBaby() && bear.canFallInLove() && bear.getAge() == 0);
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull BearEntity bear, long gameTime) {
        return this.checkExtraStartConditions(level, bear) && this.hasRequiredMemories((LivingEntity)bear);
    }

    protected void tick(@NotNull ServerLevel level, BearEntity owner, long gameTime) {
        Brain<BearEntity> brain = owner.getBrain();
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        BehaviorUtils.lookAtEntity((LivingEntity)owner, (LivingEntity)this.player);
    }

    protected void start(@NotNull ServerLevel level, BearEntity bear, long gameTime) {
        bear.stopMoving();
        bear.setPose(Pose.SNIFFING);
    }

    protected void stop(@NotNull ServerLevel level, BearEntity entity, long gameTime) {
        entity.triggerAnim("base_controller", "beg_end");
        entity.setPose(Pose.STANDING);
    }
}

