/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.generic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.mutable.MutableLong;

public class TryFindWaterSurface {
    public static BehaviorControl<PathfinderMob> create(int range, float speedModifier) {
        MutableLong mutablelong = new MutableLong(0L);
        return BehaviorBuilder.create(pathfinderMobInstance -> pathfinderMobInstance.group((App)pathfinderMobInstance.absent(MemoryModuleType.ATTACK_TARGET), (App)pathfinderMobInstance.absent(MemoryModuleType.WALK_TARGET), (App)pathfinderMobInstance.registered(MemoryModuleType.LOOK_TARGET)).apply((Applicative)pathfinderMobInstance, (attackTargetAccessor, walkTargetAccessor, lookTargetAccessor) -> (serverLevel, mob, l) -> {
            if (!mob.isUnderWater() || !mob.isInWater()) {
                return false;
            }
            if (l < mutablelong.getValue()) {
                mutablelong.setValue(l + 40L);
                return true;
            }
            BlockPos blockpos = mob.blockPosition();
            for (BlockPos blockPos1 : BlockPos.withinManhattan((BlockPos)blockpos, (int)range, (int)range, (int)range)) {
                BlockState blockState;
                if (blockPos1.getX() == blockpos.getX() && blockPos1.getZ() == blockpos.getZ() || !(blockState = serverLevel.getBlockState(blockPos1)).is(Blocks.WATER) || !serverLevel.getFluidState(blockPos1).is(FluidTags.WATER) || !serverLevel.getBlockState(blockPos1.above()).isAir()) continue;
                lookTargetAccessor.set((Object)new BlockPosTracker(blockPos1));
                walkTargetAccessor.set((Object)new WalkTarget((PositionTracker)new BlockPosTracker(blockPos1), speedModifier, 0));
                break;
            }
            mutablelong.setValue(l + 40L);
            return true;
        }));
    }
}

