/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.controls;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CrocodilePathNavigation
extends PathNavigation {
    public CrocodilePathNavigation(Mob mob, Level level) {
        super(mob, level);
    }

    @NotNull
    protected PathFinder createPathFinder(int maxVisitedNodes) {
        this.nodeEvaluator = new AmphibiousNodeEvaluator(false);
        this.nodeEvaluator.setCanPassDoors(true);
        return new PathFinder(this.nodeEvaluator, maxVisitedNodes);
    }

    protected boolean canUpdatePath() {
        return true;
    }

    @NotNull
    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), this.mob.getY(), this.mob.getZ());
    }

    protected double getGroundY(Vec3 vec3) {
        return vec3.y;
    }

    protected boolean canMoveDirectly(@NotNull Vec3 vecFrom, @NotNull Vec3 vecTo) {
        return this.mob.isInLiquid() && CrocodilePathNavigation.isClearForMovementBetween((Mob)this.mob, (Vec3)vecFrom, (Vec3)vecTo, (boolean)false);
    }

    public boolean isStableDestination(BlockPos blockPos) {
        return !this.level.getBlockState(blockPos.below()).isAir();
    }

    public void setCanFloat(boolean canFloat) {
    }
}

