/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.sensors.generic;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import org.jetbrains.annotations.NotNull;
import org.primal.registry.Primal_MemoryModuleTypes;

public class BabySensor
extends Sensor<AgeableMob> {
    @NotNull
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_VISIBLE_BABY.get()), (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }

    protected void doTick(@NotNull ServerLevel level, AgeableMob entity) {
        entity.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).ifPresent(nearestVisibleLivingEntities -> this.setNearestVisibleBaby(entity, (NearestVisibleLivingEntities)nearestVisibleLivingEntities));
    }

    private void setNearestVisibleBaby(AgeableMob mob, NearestVisibleLivingEntities nearbyEntities) {
        Optional<AgeableMob> optional = nearbyEntities.findClosest(livingEntity -> livingEntity.getType() == mob.getType() && livingEntity.isBaby()).map(AgeableMob.class::cast);
        mob.getBrain().setMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_VISIBLE_BABY.get(), optional);
    }
}

