/*
 * Decompiled with CFR 0.152.
 */
package org.primal.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.Connection;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.CrocodileEntity;
import org.primal.sounds.CrocodileSplashesSoundInstance;
import org.primal.sounds.CrocodileThrashingSoundInstance;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPlayNetworkHandlerMixin
extends ClientCommonPacketListenerImpl
implements TickablePacketListener,
ClientGamePacketListener {
    @Shadow
    private ClientLevel level;

    public ClientPlayNetworkHandlerMixin(Minecraft client, Connection connection, CommonListenerCookie connectionState) {
        super(client, connection, connectionState);
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="TAIL")}, cancellable=true)
    private void injectGhoulSound(@NotNull ClientboundEntityEventPacket packet, CallbackInfo ci) {
        Entity entity = packet.getEntity((Level)this.level);
        if (entity instanceof CrocodileEntity) {
            CrocodileEntity crocodile = (CrocodileEntity)entity;
            if (packet.getEventId() == 99) {
                this.minecraft.getSoundManager().play((SoundInstance)new CrocodileThrashingSoundInstance(crocodile));
                this.minecraft.getSoundManager().play((SoundInstance)new CrocodileSplashesSoundInstance(crocodile));
                ci.cancel();
            }
        }
    }
}

